﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt einen minimalistischen Beleg dar, welche von der Kundenbelege Komponente verwendet wird.
    /// </summary>
    public class KundenBeleg
    {
        private string _belegtyp = String.Empty;
        private string _name1 = String.Empty;

        [CompareField("BELE_A_TYP")]
        public string Belegtyp { get => _belegtyp; set => _belegtyp = value ?? String.Empty; }
        [CompareField("BELE_N_NR")]
        public int Belegnummer { get; set; }
        [CompareField("BELE_D_DATE")]
        public DateTime Belegdatum { get; set; }
        [CompareField("BELE_A_NAME1")]
        public string Name1 { get => _name1; set => _name1 = value ?? String.Empty; }
        [CompareField("BELE_N_NETTO")]
        public decimal Netto { get; set; }

        [CompareField("BELE_N_BRUTTO")]
        public decimal Brutto { get; set; }
    }
}
