﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;

namespace WK5.Core.Models
{
    public class Kostenstelle
    {
        public int KOST_N_NR { get; set; }
        public string KOST_A_BEZEICH { get; set; } = String.Empty;
        public string? KOST_A_BESCH1 { get; set; }
        public string? KOST_A_BESCH2 { get; set; }
        public string? KOST_A_BESCH3 { get; set; }
        public DateTime KOST_TIMESTAMP { get; set; }
        public int KOST_N_LASTUSER { get; set; }

        public static async IAsyncEnumerable<Kostenstelle> GetKostenstellenAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM KOSTENSTELLE ORDER BY KOST_A_BEZEICH");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Kostenstelle(), row);
            }
        }

    }
}
