﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace WK5.Core.Models.Inventuren
{
    public class InventurArtikelGebucht : IArtikel
    {
        private string _lagerplatz = String.Empty;
        private string _bezeichnung = String.Empty;

        [CompareField("ARTI_L_SN")]
        public bool BenötigtSeriennummer { get; set; }
        [CompareField("IVBE_N_NR")]
        public int BuchungsId { get; set; }
        [CompareField("IVBE_N_INVENTUR_NR")]
        public int InventurId { get; set; }
        [CompareField("IVBE_A_ARTIKELNR")]
        public string Artikelnummer { get; set; } = String.Empty;
        [CompareField("IVBE_N_MENGE")]
        [Range(0.0, double.MaxValue)]
        public decimal Menge { get; set; }
        [CompareField("IVBE_A_REGAL")]
        public string Regal { get; set; } = String.Empty;
        [CompareField("IVBE_N_USER")]
        public int UserId { get; set; }

        public decimal Differenz => TotalGebucht - Bestand;
        /// <summary>
        /// Ruft die Gesamtanzahl der Buchungen für die ausgewählte Inventur des Artikels ab, unabhängig des Regals.
        /// </summary>
        [CompareField("GEBUCHT_GESAMT")]
        public decimal TotalGebucht { get; set; }
        [CompareField("ARWE_N_BESTAND")]
        public decimal Bestand { get; set; }

        public string Bezeichnung { get => _bezeichnung; set => _bezeichnung = value ?? String.Empty; }
        [CompareField("ARTI_A_LAGER")]
        public string Lagerplatz { get => _lagerplatz; set => _lagerplatz = value ?? String.Empty; }
        public DateTime LetzterZugang { get; set; }
        public DateTime LetzteBewegung { get; set; }
        public List<InventurBuchungKommentar> Kommentare { get; set; } = new List<InventurBuchungKommentar>();
        public List<InventurBuchungSeriennummer> Seriennummern { get; set; } = new List<InventurBuchungSeriennummer>();
    }
}
