﻿using KarleyLibrary.Attributes;
using System;

namespace WK5.Core.Models.Inventuren
{
    /// <summary>
    /// Stellt einen Artikel da, welcher einem Lagerregal zugeordnet ist.
    /// </summary>
    public class InventurArtikel : IArtikel
    {
        private string _lagerplatz = String.Empty;
        private string _bezeichnung = String.Empty;
        [CompareField("ARTI_A_NR")]
        public string Artikelnummer { get; set; } = String.Empty;
        public string Bezeichnung { get => _bezeichnung; set => _bezeichnung = value ?? String.Empty; }

        [CompareField("ARTI_A_LAGER")]
        public string Lagerplatz { get => _lagerplatz; set => _lagerplatz = value ?? String.Empty; }
        [CompareField("ARWE_N_BESTAND")]
        public decimal Bestand { get; set; }
        public DateTime LetzteBewegung { get; set; }
        public DateTime LetzterZugang { get; set; }

    }
}
