﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models.Inventuren
{
    public class Inventur
    {
        [CompareField("INVE_N_NR")]
        public int InventurId { get; set; }
        [CompareField("INVE_N_JAHR")]
        public int Jahr { get; set; }
        [CompareField("INVE_L_ERLEDIGT")]
        public bool Erledigt { get; set; }

        public static async Task<Inventur?> GetInventurAsync(int inventurId)
        {
            using FbController2 fbController = new FbController2();

            fbController.AddParameter("@INVE_N_NR", inventurId);
            var row = await fbController.SelectRowAsync("SELECT * FROM WK5_INVENTUR WHERE INVE_N_NR = @INVE_N_NR");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Inventur(), row);
        }

        public async IAsyncEnumerable<Inventur> GetInventurenAsync()
        {
            using FbController2 fbController = new FbController2();
            var data = await fbController.SelectDataAsync("SELECT * FROM WK5_INVENTUR ORDER BY INVE_N_NR DESC");
            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Inventur(), row);
            }
        }
    }
}
