﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Hersteller
    {
        private string _hest_a_name1 = String.Empty;
        #region DBProps
        public string HEST_A_NR { get; set; } = String.Empty;
        public string HEST_A_NAME1 { get => _hest_a_name1; set => _hest_a_name1 = value ?? String.Empty; }
        public string? HEST_A_NAME2 { get; set; }
        public string? HEST_A_STRASSE { get; set; }
        public string? HEST_A_LAND { get; set; }
        public string? HEST_A_PLZ { get; set; }
        public string? HEST_A_ORT { get; set; }
        public string? HEST_A_TEL1 { get; set; }
        public string? HEST_A_TEL2 { get; set; }
        public string? HEST_A_FAX { get; set; }
        public string? HEST_A_EMAIL { get; set; }
        public string? HEST_A_HOMEPAGE { get; set; }
        public string? HEST_B_NOTIZ { get; set; }

        public DateTime HEST_TIMESTAMP { get; set; }
        public int HEST_N_LASTUSER { get; set; }
        #endregion

        public static async IAsyncEnumerable<Hersteller> GetHerstellerAsync()
        {
            using FbController2 fbController = new FbController2();
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM HERSTELLER");

            foreach (DataRow row in data.Rows)
            {
                if (row != null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new Hersteller(), row);
                }
            }
        }

        public static async Task<Hersteller?> GetHerstellerAsync(string HEST_A_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@HEST_A_NR", HEST_A_NR);

            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM HERSTELLER WHERE HEST_A_NR = @HEST_A_NR");

            return row == null ? null : ObjectErweiterung.DataRowZuObjekt(new Hersteller(), row);

        }

    }
}
