﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;
using KarleyLibrary.Erweiterungen;

namespace WK5.Core.Models
{
    public class Gruppe
    {
        private string _gruppenName = String.Empty;

        public int GRUP_N_ID { get; set; }
        public string GRUP_A_NAME { get => _gruppenName; set => _gruppenName = value ?? String.Empty; }
        public static async Task<Gruppe?> GetGruppeAsync(int gruppenId, FbController2 fbController)
        {
            fbController.AddParameter("@ID", gruppenId);

            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM WK5_GRUPPEN WHERE GRUP_N_ID = @ID");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Gruppe(), row);
        }

        public static async IAsyncEnumerable<Gruppe> GetAllGruppenAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM WK5_GRUPPEN");

            foreach (DataRow row in data.Rows)
            {
                if (row is not null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new Gruppe(), row);
                }
            }
        }

        public async IAsyncEnumerable<Personal> GetPersonal()
        {
            using FbController2 fbController = new FbController2();

            fbController.AddParameter("@ID", GRUP_N_ID);
            DataTable data = await fbController.SelectDataAsync("SELECT PERS.* FROM WK5_PERSONAL_ZU_GRUPPE LEFT JOIN PERSONAL PERS ON PZUG_N_PERSONAL_ID = PERS_N_NR WHEREPZUG_N_GRUPPE_ID = @ID");

            foreach (DataRow row in data.Rows)
            {
                if (row is not null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new Personal(), row);
                }
            }
        }


    }
}
