﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Erlöskonto
    {
        #region DBProperties
        public int ERKO_N_NR { get; set; }
        public int ERKO_N_LASTUSER { get; set; }
        public string? ERKO_A_BEZEICH { get; set; }
        public bool ERKO_L_AUFWAND { get; set; }
        public DateTime ERKO_TIMESTAMP { get; set; }
        #endregion

        public static async IAsyncEnumerable<Erlöskonto> GetErlöskontenAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM ERLOESKONTO ORDER BY ERKO_A_BEZEICH");

            foreach (DataRow row in data.Rows)
            {
                if (row is not null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new Erlöskonto(), row);
                }
            }
        }


        public static async Task<Erlöskonto?> GetErlöskontoAsync(int ERKO_N_NR, FbController2 fbController)
        {
            fbController.AddParameter("@ERKO_N_NR", ERKO_N_NR);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM ERLOESKONTO WHERE ERKO_N_NR = @ERKO_N_NR");

            return row == null ? null : ObjectErweiterung.DataRowZuObjekt(new Erlöskonto(), row);
        }
    }
}
