﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class EmailLogs
    {
        public int EMAIL_N_ID { get; set; }
        public string EMAIL_A_EMPFAENGER { get; set; } = String.Empty;
        public string EMAIL_A_BETREFF { get; set; } = String.Empty;
        public string EMAIL_A_BODY { get; set; } = String.Empty;
        public string EMAIL_A_SENDETYP { get; set; } = String.Empty;
        public bool EMAIL_L_SUCCESS { get; set; }
        public string EMAIL_A_FEHLER { get; set; } = String.Empty;

        public static async Task CreateAsync(string empfaenger, string betreff, string body, string sendetyp, bool success, string? fehler)
        {
            string sql = @"INSERT INTO WK5_EMAIL_LOGS 
            (
            EMAIL_A_EMPFAENGER,
            EMAIL_A_BETREFF,
            EMAIL_A_BODY,
            EMAIL_A_SENDETYP,
            EMAIL_L_SUCCESS,
            EMAIL_A_FEHLER,
            EMAIL_T_TIMESTAMP
            ) VALUES (
            @EMPFAENGER,
            @BETREFF,
            @BODY,
            @TYP,
            @SUCCESS,
            @FEHLER,
            CURRENT_TIMESTAMP
            )";
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@EMPFAENGER", empfaenger);
            fbController.AddParameter("@BETREFF", StringErweiterung.ConvertEncoding(betreff, Encoding.UTF8, Encoding.GetEncoding("ISO-8859-1")));
            fbController.AddParameter("@BODY", StringErweiterung.ConvertEncoding(body, Encoding.UTF8, Encoding.GetEncoding("ISO-8859-1")));
            fbController.AddParameter("@TYP", sendetyp);
            fbController.AddParameter("@SUCCESS", success);
            fbController.AddParameter("@FEHLER", fehler);

            await fbController.QueryAsync(sql);
        }
    }
}
