﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class CallLog
    {
        public int CALL_N_ID { get; set; }
        public string? CALL_A_TARGET { get; set; }
        public string? CALL_A_TARGET_PARSED { get; set; }
        public int CALL_N_LINE { get; set; }
        public int CALL_N_PERSONAL { get; set; }
        public bool CALL_L_SUCCESS { get; set; }
        public DateTime CALL_TIMESTAMP { get; set; }
        public string? CALL_A_REASON { get; set; }
        public async Task<CallLog> CreateAsync()
        {
            using FbController2 fbController = new FbController2();

            string sql = "INSERT INTO WK5_CALL_LOG (CALL_A_TARGET, CALL_A_TARGET_PARSED, CALL_N_LINE, CALL_N_PERSONAL, CALL_L_SUCCESS, CALL_A_REASON) VALUES (@CALL_A_TARGET, @CALL_A_TARGET_PARSED, @CALL_N_LINE, @CALL_N_PERSONAL, @CALL_L_SUCCESS, @CALL_A_REASON) RETURNING CALL_N_ID";

            fbController.AddParameter("@CALL_A_TARGET", CALL_A_TARGET ?? String.Empty);
            fbController.AddParameter("@CALL_A_TARGET_PARSED", CALL_A_TARGET_PARSED ?? String.Empty);
            fbController.AddParameter("@CALL_N_LINE", CALL_N_LINE);
            fbController.AddParameter("@CALL_N_PERSONAL", CALL_N_PERSONAL);
            fbController.AddParameter("@CALL_L_SUCCESS", CALL_L_SUCCESS);
            fbController.AddParameter("@CALL_A_REASON", CALL_A_REASON);

            object? idObj = await fbController.FetchObjectAsync(sql);

            if (idObj is not null)
            {
                CALL_N_ID = Convert.ToInt32(idObj);
            }

            return this;
        }
    }
}
