﻿using KarleyLibrary.Erweiterungen;
using System;

namespace WK5.Core.Models.Bestellungen
{
    public class AuftragBestellenPosition
    {
        public AuftragBestellenArtikel SelectedArtikel { get; set; }



        // Wir nehmen greifen nicht direkt auf die Daten von SelectedArtikel zu, da der Mitarbeiter diese später noch abändern kann.
        public string Artikelnummer { get; set; } = String.Empty;
        public string? Bezeichnung1 { get; set; }
        public string? Bezeichnung2 { get; set; }
        public string? Bezeichnung3 { get; set; }
        public string? Bezeichnung4 { get; set; }
        public string? Bezeichnung5 { get; set; }
        public decimal Menge { get; set; }
        public decimal Preis { get; set; }
        public decimal Rabatt1 { get; set; }
        public decimal Rabatt2 { get; set; }

        

        public decimal PreisMitRabatt
        {
            get
            {
                decimal preis = Preis;

                if (Rabatt1 > 0)
                {
                    preis *= (100 - Rabatt1) / 100;
                }

                if (Rabatt2 > 0)
                {
                    preis *= (100 - Rabatt2) / 100;
                }

                return preis;
            }
        }
        public string? Bestellnummer { get; set; }
        public DateTime Lieferdatum { get; set; }

        public bool DruckLangtext { get; set; }
        public string? Langtext { get; set; }
        public AuftragBestellenPosition(AuftragBestellenArtikel artikel, AuftragBestellenLieferantArtikel lfArtikel)
        {
            SelectedArtikel = artikel;
            Artikelnummer = artikel.Artikelnummer;
            Bestellnummer = lfArtikel.Bestellnummer;
            Bezeichnung1 = lfArtikel.Bezeichnung1;
            Bezeichnung2 = lfArtikel.Bezeichnung2;
            Bezeichnung3 = lfArtikel.Bezeichnung3;
            Bezeichnung4 = lfArtikel.Bezeichnung4;
            Bezeichnung5 = String.Empty;
            Preis = lfArtikel.GetPreis(artikel.Menge);
            Menge = artikel.Menge;
            var (rabatt1, rabatt2) = lfArtikel.GetRabatte(artikel.Menge);
            Rabatt1 = rabatt1;
            Rabatt2 = rabatt2;
            Langtext = StringErweiterung.RtfToString(lfArtikel.Langtext);

            int addDays = 1;
            if (DateTime.Today.DayOfWeek is DayOfWeek.Friday)
            {
                addDays = 3;
            }

            if (DateTime.Today.Hour >= 14 && addDays is not 3)
            {
                addDays = 2;
            }

            Lieferdatum = DateTime.Now.AddDays(addDays);
        }
    }
}
