﻿using KarleyLibrary.Attributes;
using System;
using System.Linq;

namespace WK5.Core.Models.Bestellungen
{
    public class AuftragBestellenLieferant
    {
        [CompareField("ARLI_N_LIEFNR")]
        public int LieferantId { get; set; }
        [CompareField("LIEF_A_NAME1")]
        public string LieferantName { get; set; } = String.Empty;
        [CompareField("LIEF_WK5_L_DIREKT_ERLAUBT")]
        public bool DirektLieferungErlaubt { get; set; }
        [CompareField("LIEF_N_ZABD")]
        public int Zahlungsbedingung { get; set; }
        [CompareField("LIEF_N_LIBD")]
        public int Lieferbedingung { get; set; }
        [CompareField("LIEF_A_WAEHRUNG")]
        public string Währung { get; set; } = String.Empty;
        [CompareField("LIEF_N_MIDBESTWERT")]
        public decimal Mindestbestellwert { get; set; }
        [CompareField("LIEF_WK5_N_MINDERMENGENZUSCHLAG")]
        public decimal Mindermengenzuschlag { get; set; }
        public AnsprechpartnerLieferant[] Ansprechpartner { get; set; } = Array.Empty<AnsprechpartnerLieferant>();
        [CompareField("LIEF_A_LAND")]
        public string Land { get; set; } = string.Empty;
        public override string ToString()
        {
            return $"{LieferantId} - {LieferantName}";
        }
    }
}
