﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class BestellungAbruf
    {
        [CompareField("BEAB_N_NR")]
        public int Id { get; set; }
        [CompareField("BEAB_N_BESTNR")]
        public int Bestellnummer { get; set; }
        [CompareField("BEAB_D_ANLAGEDATUM")]
        public DateTime Anlagedatum { get; set; }
        [CompareField("BEAB_N_LASTUSER")]
        public int MitarbeiterId { get; set; }
        public List<BestellungAbrufPos> Positionen { get; set; } = new List<BestellungAbrufPos>();
    }

    public class BestellungAbrufPos
    {
        [CompareField("BABP_N_ABRUFNR")]
        public int AbrufId { get; set; }
        [CompareField("BABP_N_POSID")]
        public int PosId { get; set; }
        [CompareField("BABP_N_MENGE")]
        public decimal Menge { get; set; }
        [CompareField("ARTIKELNUMMER")]
        public string Artikelnummer { get; set; } = string.Empty;
    }
}
