﻿using System;
using System.Text;
using System.Text.RegularExpressions;

namespace WK5.Core.Models
{
    public class Bestellposition
    {
        private decimal _mindestabnahme;
        #region Datenbankfelder
        public int BEPO_N_POSID { get; set; }
        public string BEPO_A_ARTIKELNR { get; set; } = String.Empty;
        public string? BEPO_A_BESTELLNUMMER { get; set; }
        public string BEPO_A_BEZ1 { get; set; } = String.Empty;
        public string? BEPO_A_BEZ2 { get; set; }
        public string? BEPO_A_BEZ3 { get; set; }
        public string? BEPO_A_BEZ4 { get; set; }
        public string? BEPO_A_BEZ5 { get; set; }
        public string? BEPO_A_MASSEINHEIT { get; set; }
        public string? BEPO_A_NOTIZ { get; set; }
        public string? BEPO_A_OPTION { get; set; }
        public string? BEPO_A_TERMINTEXT { get; set; }

        public DateTime BEPO_D_DAT_BESTAETIGT { get; set; }
        public DateTime BEPO_D_LIEFERDAT { get; set; }

        public bool BEPO_L_ERLEDIGT { get; set; }
        public bool BEPO_L_IMVERSAND { get; set; }
        public bool BEPO_L_STEUERFREI { get; set; }
        public bool BEPO_L_STORNIERT { get; set; }
        public bool BEPO_L_ZERTI_BEN { get; set; }
        public bool BEPO_L_ZERTI_ERHALT { get; set; }

        public int BEPO_N_BESTNR { get; set; }
        public int BEPO_N_GARANTIE { get; set; }
        public int BEPO_N_LASTUSER { get; set; }
        public int BEPO_N_POS { get; set; } = -1;

        public decimal BEPO_N_BODEN { get; set; }
        public decimal BEPO_N_BREITE { get; set; }
        public decimal BEPO_N_BREITE2 { get; set; }
        public decimal BEPO_N_HOEHE { get; set; }
        public decimal BEPO_N_HOEHE2 { get; set; }
        public decimal BEPO_N_LAENGE { get; set; }
        public decimal BEPO_N_LAENGE2 { get; set; }
        public decimal BEPO_N_LIEFERMENGE { get; set; }
        public decimal BEPO_N_MENGE { get; set; }
        public decimal BEPO_N_MENGENFAKTOR { get; set; }
        public decimal BEPO_N_MWSTPROZ { get; set; }
        public decimal BEPO_N_PREIS { get; set; }
        public decimal BEPO_N_RABATTPROZ { get; set; }
        public decimal BEPO_N_RABATTPROZ2 { get; set; }
        public decimal BEPO_N_STAERKE { get; set; }
        public DateTime BEPO_TIMESTAMP { get; set; }
        #endregion
        /// <summary>
        /// Gibt an, dass nur ein Vielfaches der <see cref="Mindestabnahme"/> bestellt werden können.
        /// </summary>
        public bool ARLI_L_NURVIELFACHES { get; set; }
        /// <summary>
        /// Flag für zum Überprüfen der Bestellung. Das Flag wird nicht automatisch gesetzt und wird nur von BestellungPrüfen.razor verwendet.
        /// </summary>
        public string GetBezeichnung() => Regex.Replace($"{BEPO_A_BEZ1} {BEPO_A_BEZ2} {BEPO_A_BEZ3} {BEPO_A_BEZ4} {BEPO_A_BEZ5}", "  +/g", " ").Trim();
        public bool Geprüft { get; set; }

        public decimal Mindestabnahme { get => _mindestabnahme; set => _mindestabnahme = value <= 0 ? 1 : value; }
        public decimal PreisMitRabatt
        {
            get
            {
                decimal preis = BEPO_N_PREIS;

                if (BEPO_N_RABATTPROZ > 0)
                {
                    preis *= (100 - BEPO_N_RABATTPROZ) / 100;
                }

                if (BEPO_N_RABATTPROZ2 > 0)
                {
                    preis *= (100 - BEPO_N_RABATTPROZ2) / 100;
                }

                return preis;
            }
        }

        public Bestellposition()
        {
            int addDays = 1;
            if (DateTime.Today.DayOfWeek is DayOfWeek.Friday)
            {
                addDays = 3;
            }

            if (DateTime.Today.Hour >= 14 && addDays is not 3)
            {
                addDays = 2;
            }

            BEPO_D_LIEFERDAT = DateTime.Now.AddDays(addDays);
        }
    }
}
