﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Data;
using System.Runtime.CompilerServices;
using System.Threading;

namespace WK5.Core.Models
{
    public class Bestelldisposition
    {
        private string _artikelnummer = String.Empty;
        private string _artikelBezeichnung = String.Empty;
        private decimal _bestellvorschlag;

        [CompareField("ARTI_A_NR")]
        public string Artikelnummer { get => _artikelnummer; set => _artikelnummer = value ?? String.Empty; }
        [CompareField("ARTI_A_BEZ1")]
        public string ArtikelBezeichnung { get => _artikelBezeichnung; set => _artikelBezeichnung = value ?? String.Empty; }

        [CompareField("BESTELLVORSCHLAG")]
        public decimal Bestellvorschlag { get => Mindestabnahme > _bestellvorschlag ? Mindestabnahme : _bestellvorschlag; set => _bestellvorschlag = value; }
        [CompareField("BESTELLVORSCHLAG_EURO")]
        public decimal BestellvorschlagEuro { get; set; }
        [CompareField("BESTELLWERT")]
        public decimal Bestellwert { get; set; }
        [CompareField("ARWE_N_BESTAND")]
        public decimal Bestand { get; set; }
        [CompareField("ARWE_N_BEDARF")]
        public decimal Bedarf { get; set; }
        [CompareField("ARWE_N_OFFBESTELL")]
        public decimal Bestellt { get; set; }

        [CompareField("ARTI_N_MINBESTAND")]
        public decimal Mindestbestand { get; set; }
        [CompareField("BEZAHLTER_BEDARF")]
        public decimal BezahlterBedarf { get; set; }
        [CompareField("ARTI_L_INAKTIV")]
        public bool IstArtikelAktiv { get; set; }
        [CompareField("LETZTER_ZUGANG")]
        public decimal LetzerZugang { get; set; }
        [CompareField("ARTI_L_ABVERKAUF")]
        public bool IstAbverkauf { get; set; }
        [CompareField("ARLI_N_MINDESTABNAHME")]
        public decimal Mindestabnahme { get; set; }

        public async IAsyncEnumerable<(decimal menge, decimal preis, decimal rabatt)> GetStaffelpreiseAsync(int lieferantenId, [EnumeratorCancellation] CancellationToken cancellationToken)
        {
            cancellationToken.ThrowIfCancellationRequested();
            if (lieferantenId is not 0)
            {
                using FbController2 fbController = new FbController2();
                var lieferantenartikel = await Lieferantenartikel.GetLieferantenartikelAsync(Artikelnummer, lieferantenId, fbController);

                if (lieferantenartikel is not null && !cancellationToken.IsCancellationRequested)
                {
                    if (lieferantenartikel.ARLI_N_MENGE1 > 0 && (lieferantenartikel.ARLI_N_PREISMENGE1 > 0 || lieferantenartikel.ARLI_N_RABATTMENGE1 > 0))
                    {
                        yield return (lieferantenartikel.ARLI_N_MENGE1, lieferantenartikel.ARLI_N_PREISMENGE1, lieferantenartikel.ARLI_N_RABATTMENGE1);
                    }

                    if (lieferantenartikel.ARLI_N_MENGE2 > 0 && (lieferantenartikel.ARLI_N_PREISMENGE2 > 0 || lieferantenartikel.ARLI_N_RABATTMENGE2 > 0))
                    {
                        yield return (lieferantenartikel.ARLI_N_MENGE2, lieferantenartikel.ARLI_N_PREISMENGE2, lieferantenartikel.ARLI_N_RABATTMENGE2);
                    }

                    if (lieferantenartikel.ARLI_N_MENGE3 > 0 && (lieferantenartikel.ARLI_N_PREISMENGE3 > 0 || lieferantenartikel.ARLI_N_RABATTMENGE3 > 0))
                    {
                        yield return (lieferantenartikel.ARLI_N_MENGE3, lieferantenartikel.ARLI_N_PREISMENGE3, lieferantenartikel.ARLI_N_RABATTMENGE3);
                    }

                    if (lieferantenartikel.ARLI_N_MENGE4 > 0 && (lieferantenartikel.ARLI_N_PREISMENGE4 > 0 || lieferantenartikel.ARLI_N_RABATTMENGE4 > 0))
                    {
                        yield return (lieferantenartikel.ARLI_N_MENGE4, lieferantenartikel.ARLI_N_PREISMENGE4, lieferantenartikel.ARLI_N_RABATTMENGE4);
                    }
                }
            }
        }

        public async IAsyncEnumerable<Auftrag> GetBelegeMitPositionAsync(FbController2 fbController, [EnumeratorCancellation] CancellationToken cancellationToken)
        {
            cancellationToken.ThrowIfCancellationRequested();
            fbController.AddParameter("@BPOS_A_ARTIKELNR", Artikelnummer);
            var data = await fbController.SelectDataAsync(@"SELECT DISTINCT AB.BPOS_N_NR FROM ARTIKEL_BEDARF AB 
LEFT JOIN BELEGE B ON (B.BELE_A_TYP = 'AU' AND B.BELE_N_NR = AB.BPOS_N_NR)
WHERE BPOS_A_ARTIKELNR = @BPOS_A_ARTIKELNR AND BELE_L_ERLEDIGT = 'N'");


            foreach (DataRow row in data.Rows)
            {
                cancellationToken.ThrowIfCancellationRequested();
                int belegnummer = row.Field<int>("BPOS_N_NR");

                if (belegnummer > 0)
                {
                    var auftrag = await Auftrag.GetAuftragAsync(belegnummer, fbController);

                    if (auftrag is not null)
                    {
                        cancellationToken.ThrowIfCancellationRequested();
                        yield return auftrag;
                    }
                }
            }
        }



    }
}
