﻿using KarleyLibrary.Attributes;
using System;

namespace WK5.Core.Models
{
    public class BelegÜbersicht
    {
        private string _belegtyp = string.Empty;
        private string _name1 = string.Empty;
        private string _name2 = string.Empty;
        private string _name3 = string.Empty;
        private string _ort = string.Empty;
        private string _postleitzahl = string.Empty;
        private string _strasse = string.Empty;
        private string _land = string.Empty;
        private string _telefon = string.Empty;
        private string _kundennummer = string.Empty;
        private string _bestätigungsNummer = string.Empty;

        [CompareField("BELE_A_TYP")]
        public string BELU_A_TYP { get => _belegtyp; set => _belegtyp = value ?? string.Empty; }
        [CompareField("BELE_N_NR")]
        public int BELU_N_NR { get; set; }
        [CompareField("BELE_A_NAME1")]
        public string BELU_A_NAME1 { get => _name1; set => _name1 = value ?? string.Empty; }
        [CompareField("BELE_A_NAME2")]
        public string BELU_A_NAME2 { get => _name2; set => _name2 = value ?? string.Empty; }
        [CompareField("BELE_A_NAME3")]
        public string BELU_A_NAME3 { get => _name3; set => _name3 = value ?? string.Empty; }
        [CompareField("BELE_A_ORT")]
        public string BELU_A_ORT { get => _ort; set => _ort = value ?? string.Empty; }
        [CompareField("BELE_A_PLZ")]
        public string BELU_A_PLZ { get => _postleitzahl; set => _postleitzahl = value ?? string.Empty; }
        [CompareField("BELE_A_STRASSE")]
        public string BELU_A_STRASSE { get => _strasse; set => _strasse = value ?? string.Empty; }
        [CompareField("BELE_A_LAND")]
        public string BELU_A_LAND { get => _land; set => _land = value ?? string.Empty; }
        public string BELU_A_TELEFON { get => _telefon; set => _telefon = value ?? string.Empty; }
        [CompareField("BELE_A_KUNDENNR")]
        public string BELU_A_KUNDNR { get => _kundennummer; set => _kundennummer = value ?? string.Empty; }
        [CompareField("BELE_N_NETTO")]
        public decimal BELU_N_NETTO { get; set; }
        [CompareField("BELE_N_BRUTTO")]
        public decimal BELU_N_BRUTTO { get; set; }
        [CompareField("BELE_N_MWST_SATZ1")]
        public decimal BELU_N_STEUERSATZ { get; set; }
        [CompareField("BELE_N_MWST")]
        public decimal BELU_N_STEUERWERT { get; set; }
        [CompareField("BELE_A_STATUSFELD")]
        public string BELU_A_STATUS { get; set; } = string.Empty;
        [CompareField("BELE_D_DATE")]
        public DateTime BELU_D_DATE { get; set; }
        [CompareField("BELE_A_GRUPPE")]
        public string BELU_A_GRUPPE { get; set; } = string.Empty;
        [CompareField("WK5_BELE_L_DIREKTLIEFERUNG")]
        public bool BELU_L_DIREKTLIEFERUNG { get; set; }
        [CompareField("BELE_A_BESTAET_NR")]
        public string BELU_A_BESTAETNR { get => _bestätigungsNummer; set => _bestätigungsNummer = value ?? string.Empty; }
        [CompareField("BELE_N_NR_AN")]
        public int BELU_N_AN_NUMMER { get; set; }
        [CompareField("BELE_N_NR_AU")]
        public int BELU_N_AU_NUMMER { get; set; }
        [CompareField("BELE_N_NR_LS")]
        public int BELU_N_LS_NUMMER { get; set; }
        [CompareField("BELE_N_NR_RE")]
        public int BELU_N_RE_NUMMER { get; set; }
        [CompareField("BELE_N_NR_GU")]
        public int BELU_N_GU_NUMMER { get; set; }

        [CompareField("BELE_D_LIEFERDATE")]
        public DateTime BELU_D_LIEFERDATE { get; set; }
        [CompareField("BELE_D_NACHFRAGDAT")]
        public DateTime BELU_D_NACHFRAGEDATE { get; set; }
        [CompareField("BELE_D_FIBUUEBERGDATE")]
        public DateTime BELU_D_UEBERGABEDATE { get; set; }
        [CompareField("BELE_L_ARCHIVIERT_KARLEY")]
        public bool BELU_L_ARCHIVIERT { get; set; }
        [CompareField("BELE_L_ERLEDIGT")]
        public bool BELU_L_ERLEDIGT { get; set; }
        [CompareField("BELE_L_FIBUUEBERGABE")]
        public bool BELU_L_FIBU { get; set; }
        [CompareField("BELE_L_MWST")]
        public bool BELU_L_MWST { get; set; }
        [CompareField("BELE_L_NEUTRAL")]
        public bool BELU_L_NEUTRAL { get; set; }
        [CompareField("BELE_N_ANLAGEUSER")]
        public int BELU_N_ANLAGEUSER { get; set; }
        [CompareField("BELE_N_VERTRETER")]
        public int BELU_N_VERTRETER { get; set; }
        [CompareField("BELE_N_ZAHLUNG")]
        public int BELU_N_ZAHLUNG { get; set; }
        [CompareField("BELE_N_LIEFERUNG")]
        public int BELU_N_LIEFERUNG { get; set; }
        [CompareField("WK5_BELE_L_PAUSIERT")]
        public bool BELU_L_PAUSIERT { get; set; }
        [CompareField("WK5_BELE_L_SAMMELRECHNUNG")]
        public bool BELU_L_SAMMELRECHNUNG { get; set; }
        [CompareField("WK5_BELE_L_WIEDERVORLAGE")]
        public bool BELU_L_WIEDERVORLAGE { get; set; }
        [CompareField("BELE_L_BEZAHLT")]
        public bool BELU_L_BEZAHLT { get; set; }
        [CompareField("BELE_L_STORNO")]
        public bool BELU_L_STORNIERT { get; set; }
        public string GetRowClass()
        {
            if (BELU_L_STORNIERT)
            {
                return "table-danger";
            }

            if (BELU_L_ERLEDIGT || BELU_L_BEZAHLT)
            {
                return "table-success";
            }


            return String.Empty;
        }
    }
}
