﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Repräsentiert die Tablelle BELEGCHARGEN aus der Datenbank
    /// </summary>
    public class Belegcharge
    {
        private string _artikelnummer = String.Empty;
        #region Datenbankfelder
        public int BCHA_N_ID { get; set; }
        public int BCHA_N_POSID { get; set; }
        public int BCHA_N_CHARGE { get; set; }
        public int BCHA_N_STCKLPOSID { get; set; }
        public int BCHA_N_FERTID { get; set; }
        public int BCHA_N_LASTUSER { get; set; }

        public bool BCHA_L_STCKLCHARGE { get; set; }
        public DateTime BCHA_TIMESTAMP { get; set; }
        public decimal BCHA_N_MENGE { get; set; }

        public string Artikelnummer { get => _artikelnummer; set => _artikelnummer = value ?? String.Empty; }
        #endregion

        /// <summary>
        /// Lädt eine Belegcharge von einer Belegchargen Id
        /// </summary>
        /// <param name="BCHA_N_ID">Die Belegchargen Id aus der sich die Belegcharge geladen werden soll</param>
        /// <returns>Gibt ein Objekt der Klasse <see cref="Belegcharge"/> zurück was die Daten der Belegcharge enthält</returns>
        public static async Task<Belegcharge?> GetBelegchargeAsync(int BCHA_N_ID)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@ID", BCHA_N_ID);
            var row = await fbController.SelectRowAsync(@"SELECT BELEGCHARGEN.*, 
    CASE WHEN BCHA_N_STCKLPOSID > 0 THEN 
         (SELECT BSTU_A_UNTERARTI FROM BELEGSTUECKLISTE WHERE BSTU_N_POSID = BCHA_N_STCKLPOSID) 
    ELSE
         (SELECT BPOS_A_ARTIKELNR FROM BELEGPOS WHERE BPOS_N_POSID = BCHA_N_POSID)
    END AS ARTIKELNUMMER
FROM BELEGCHARGEN WHERE BCHA_N_ID = @ID");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Belegcharge(), row);
        }



        /// <summary>
        /// Lädt eine Liste an Belegchargen die zu einer Belegposition gehören
        /// </summary>
        /// <param name="BPOS_N_POSID">Die Positions Id der Belegposition zu der die Belegchargen geladen werden sollen</param>
        /// <returns>Gibt eine <see cref="List{Belegcharge}"/> zurück die die Belegchargen enthält die zu der Position gehören</returns>
        public static async IAsyncEnumerable<Belegcharge> GetPositionsChargenAsync(int BPOS_N_POSID, int STCKLPOSID = 0)
        {
            using FbController2 fbController = new FbController2();
            string sql = @"SELECT BELEGCHARGEN.*,
    CASE WHEN BCHA_N_STCKLPOSID > 0 THEN 
         (SELECT BSTU_A_UNTERARTI FROM BELEGSTUECKLISTE WHERE BSTU_N_POSID = BCHA_N_STCKLPOSID) 
    ELSE
         (SELECT BPOS_A_ARTIKELNR FROM BELEGPOS WHERE BPOS_N_POSID = BCHA_N_POSID)
    END AS ARTIKELNUMMER
FROM BELEGCHARGEN 
WHERE BCHA_N_POSID = @POSID AND BCHA_N_STCKLPOSID = @STCKLPOSID";
            fbController.AddParameter("@POSID", BPOS_N_POSID);
            fbController.AddParameter("@STCKLPOSID", STCKLPOSID);

            DataTable data = await fbController.SelectDataAsync(sql);

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Belegcharge(), row);
            }
        }

        /// <summary>
        /// Lädt alle zugewiesenen Belegchargen für einen Lieferschein
        /// </summary>
        /// <param name="lieferscheinNummer"></param>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public static async IAsyncEnumerable<Belegcharge> GetLieferscheinChargenAsync(int lieferscheinNummer, FbController2 fbController)
        {
            fbController.AddParameter("@BPOS_N_NR", lieferscheinNummer);
            DataTable data = await fbController.SelectDataAsync(@"SELECT BC.*,
CASE WHEN BCHA_N_STCKLPOSID > 0 THEN 
         (SELECT BSTU_A_UNTERARTI FROM BELEGSTUECKLISTE WHERE BSTU_N_POSID = BCHA_N_STCKLPOSID) 
    ELSE
         BPOS_A_ARTIKELNR
    END AS ARTIKELNUMMER
FROM BELEGPOS BP
INNER JOIN BELEGCHARGEN BC ON BC.BCHA_N_POSID = BP.BPOS_N_POSID 
WHERE BPOS_A_TYP = 'LS' AND BPOS_N_NR = @BPOS_N_NR");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Belegcharge(), row);
            }
        }
    }
}
