﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class BelegChange
    {
        #region Datenbankfelder
        public string BCNG_A_BELEGTYP { get; set; } = String.Empty;
        public string? BCNG_A_FELD { get; set; }
        public string? BCNG_A_WERTALT { get; set; }
        public string? BCNG_A_WERTNEU { get; set; }
        public int BCNG_N_ART { get; set; }
        public string? BCNG_N_BELEGNR { get; set; }
        public int BCNG_N_ID { get; set; }
        public int BCNG_N_POSNR { get; set; }
        public int BCNG_N_USER { get; set; }
        public DateTime BCNG_TIMESTAMP { get; set; }
        #endregion

        public static async Task<bool> InsertBelegChangeAsync(FbController2 fbController, BelegChange change)
        {

            fbController.AddParameter("@INP_TYP", change.BCNG_A_BELEGTYP);
            fbController.AddParameter("@INP_BELEGNR", change.BCNG_N_BELEGNR);
            fbController.AddParameter("@INP_ART", change.BCNG_N_ART);
            fbController.AddParameter("@INP_ALT", change.BCNG_A_WERTALT);
            fbController.AddParameter("@INP_NEU", change.BCNG_A_WERTNEU);
            fbController.AddParameter("@INP_POSITION", change.BCNG_N_POSNR);


            await fbController.RunProcedureAsync("PROZ_BELEGHIST_INSERT");

            return true;
        }
    }

    public class BelegChangeAnsicht
    {
        private string _username = String.Empty;
        private string _art = String.Empty;
        private string _alterWert = String.Empty;
        private string _neuerWert = String.Empty;

        [CompareField("OUT_DATUM")]
        public DateTime Datum { get; set; }
        [CompareField("OUT_USERNAME")]
        public string Username { get => _username; set => _username = value ?? "Unbekannt"; }
        [CompareField("OUT_TEXT")]
        public string Art { get => _art; set => _art = value ?? "Unbekannt"; }
        [CompareField("OUT_VON")]
        public string AlterWert { get => _alterWert; set => _alterWert = value ?? String.Empty; }
        [CompareField("OUT_NACH")]
        public string NeuerWert { get => _neuerWert; set => _neuerWert = value ?? String.Empty; }
        public static async IAsyncEnumerable<BelegChangeAnsicht> GetHistorieAsync(string BCNG_A_BELEGTYP, string BCNG_N_BELEGNR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@INP_BELEGTYP", BCNG_A_BELEGTYP);
            fbController.AddParameter("@INP_BELEGNR", BCNG_N_BELEGNR.ToString());
            bool useSnHistorie = Int32.TryParse(BCNG_N_BELEGNR, out int belegnummer);
            var data = await fbController.SelectDataAsync($@"SELECT * FROM 
(
    SELECT * FROM PROZ_BELEGHIST(@INP_BELEGTYP, @INP_BELEGNR)
        {(useSnHistorie ? $@"union all 
    SELECT SNHI_TIMESTAMP as OUT_DATUM, PERS_A_NAME || ' ' || PERS_A_VORNAME AS OUT_USERNAME, CHAR_A_ARTINR AS OUT_TEXT, SNHI_A_SN AS OUT_VON, SNHI_N_NOTIZ AS OUT_NACH 
    FROM SNHISTORIE 
    LEFT JOIN PERSONAL ON PERS_N_NR = SNHI_N_LASTUSER
    LEFT JOIN CHARGEN ON CHAR_N_NR = SNHI_N_CHARGE
    WHERE SNHI_A_BELEART = @INP_BELEGTYP AND SNHI_N_BELENR = @INP_BELEGNR" : String.Empty)}
)
ORDER BY OUT_DATUM DESC");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new BelegChangeAnsicht(), row);
            }
        }
    }


}
