﻿using KarleyLibrary.Attributes;
using System;
using System.Text.RegularExpressions;

namespace WK5.Core.Models
{
    public class ArtikelÜbersicht
    {
        private decimal _artu_n_bestand;

        [CompareField("ARTI_A_NR")]
        public string ARTU_A_NR { get; set; } = String.Empty;
        [CompareField("ARTI_A_BEZ1")]
        public string ARTU_A_BEZ1 { get; set; } = String.Empty;
        [CompareField("ARTI_A_BEZ2")]
        public string? ARTU_A_BEZ2 { get; set; }
        [CompareField("ARTI_A_BEZ3")]
        public string? ARTU_A_BEZ3 { get; set; }
        [CompareField("ARWE_N_BEDARF")]
        public decimal ARTU_N_BEDARF { get; set; }

        [CompareField("ARWE_N_BESTAND")]
        public decimal ARTU_N_BESTAND { get => _artu_n_bestand + StücklistenBestand; set => _artu_n_bestand = value; }
        public decimal ARTU_N_FREI { get => ARTU_N_BESTAND - ARTU_N_BEDARF; }
        [CompareField("ARWE_N_OFFBESTELL")]
        public decimal ARTU_N_BESTELLT { get; set; }
        [CompareField("ARTI_N_EK")]
        public decimal ARTU_N_EK { get; set; }
        [CompareField("ARTI_N_VK1")]
        public decimal ARTU_N_VK { get; set; }
        [CompareField("ARTI_A_EAN")]
        public string? ARTU_A_EAN { get; set; }
        [CompareField("ARTI_A_HERST_NR")]
        public string? ARTU_A_HERST_NR { get; set; }
        [CompareField("WK5_ARTI_A_SUCHBEGRIFF")]
        public string? ARTU_A_SUCHBEGRIFF { get; set; }
        [CompareField("ARTI_A_WARENGRUPPE")]
        public string? ARTU_A_WARENGRUPPE { get; set; }
        [CompareField("ARTI_A_UNTERWARENG")]
        public string? ARTU_A_UNTERWARENGRUPPE { get; set; }
        [CompareField("ARTI_L_INAKTIV")]
        public bool ARTU_L_INAKTIV { get; set; }
        [CompareField("ARTI_L_LAGERFUEHR")]
        public bool ARTU_L_LAGERFUEHRUNG { get; set; }
        [CompareField("WK5_ARTI_N_WICHTIGKEIT")]
        public int ARTU_N_WICHTIGKEIT { get; set; }
        public decimal ARTU_N_ANGEBOTSPREIS { get; set; }
        [CompareField("WK5_ARWE_N_BESTAND_STUECKLISTE")]
        public decimal StücklistenBestand { get; set; }
        [CompareField("WK5_ARTI_N_ANGEBOTVORLAGE")]
        public int Angebotsvorlage { get; set; }

        public string GetBezeichnung() => Regex.Replace($"{ARTU_A_BEZ1} {ARTU_A_BEZ2} {ARTU_A_BEZ3}", "  +/g", " ").Trim();
    }
}
