﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Artikelwerte
    {
        #region DBProps
        public string ARWE_A_NR { get; set; } = String.Empty;
        public int ARWE_N_LASTUSER { get; set; }
        public DateTime ARWE_D_LETZBEWEG { get; set; }
        public DateTime ARWE_D_LAGERDATUM { get; set; }
        public DateTime ARWE_D_INVENTDATUM { get; set; }
        public DateTime ARWE_D_LETZTEREKDATUM { get; set; }
        public DateTime ARWE_TIMESTAMP { get; set; }
        public decimal ARWE_N_BESTAND { get; set; }
        public decimal ARWE_N_BEDARF { get; set; }
        public decimal ARWE_N_BEDARF_FERT { get; set; }
        public decimal ARWE_N_BEDARF_RUEST { get; set; }
        public decimal ARWE_N_BEDARF_FERT_RUEST { get; set; }
        public decimal ARWE_N_BESTAND_EUR { get; set; }
        public decimal ARWE_N_LAGERUMSCHL { get; set; }
        public decimal ARWE_N_TIEFSTEREK { get; set; }
        public decimal ARWE_N_HOECHSTEREK { get; set; }
        public decimal ARWE_N_DURCHSCHEK { get; set; }
        public decimal ARWE_N_VKDURCHSCHN { get; set; }
        public decimal ARWE_N_KOMMLAGER { get; set; }
        public decimal ARWE_N_INVENTMONEY { get; set; }
        public decimal ARWE_N_LETZTEREK { get; set; }
        public decimal ARWE_N_LAGERBESTA { get; set; }
        public decimal ARWE_N_GESABEDARF { get; set; }
        public decimal ARWE_N_INVENTDIFF { get; set; }
        public decimal ARWE_N_INVENTBEST { get; set; }
        public decimal ARWE_N_OFFBESTELL { get; set; }
        public decimal ARWE_N_LAGMENGDAU { get; set; }
        public decimal ARWE_N_LAGERDAUER { get; set; }
        #endregion

        public static async Task<Artikelwerte?> GetArtikelwertAsync(string ARWE_A_NR, FbController2 fbController)
        {
            string sql = "SELECT * FROM ARTIKELWERTE WHERE ARWE_A_NR = @ARWE_A_NR";
            fbController.AddParameter("@ARWE_A_NR", ARWE_A_NR);

            DataRow? row = await fbController.SelectRowAsync(sql);
            return row == null ? null : ObjectErweiterung.DataRowZuObjekt(new Artikelwerte(), row);
        }
    }
}
