﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class ArtikelZubehör
    {
        public string ARZU_A_AUSGANGSART { get; set; } = String.Empty;
        public string ARZU_A_ZUBEHOERART { get; set; } = String.Empty;
        public string? ARZU_B_NOTIZ { get; set; }
        public int ARZU_N_POS { get; set; }
        public DateTime ARZU_TIMESTAMP { get; set; }
        public int ARZU_N_LASTUSER { get; set; }
        public string Beschreibung { get; set; } = string.Empty;

        public static async IAsyncEnumerable<ArtikelZubehör> GetArtikelZubehörAsync(string ARTI_A_NR, FbController2 fbController)
        {
            string sql = @"SELECT 
AZ.*,
TRIM(trailing from COALESCE(A.ARTI_A_BEZ1,'') || ' ' || COALESCE(A.ARTI_A_BEZ2,'') || ' ' || COALESCE(A.ARTI_A_BEZ3,'') || ' ' || COALESCE(A.ARTI_A_BEZ4,'') || ' ' || COALESCE(A.ARTI_A_BEZ5,'')) as Beschreibung 
FROM ARTIKELZUBEHOER AZ 
LEFT JOIN ARTIKEL A ON AZ.ARZU_A_ZUBEHOERART = A.ARTI_A_NR 
WHERE AZ.ARZU_A_AUSGANGSART = @ARTINR";

            fbController.AddParameter("@ARTINR", ARTI_A_NR);

            DataTable data = await fbController.SelectDataAsync(sql);

            foreach (DataRow row in data.Rows)
            {
                if (row is not null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new ArtikelZubehör(), row);
                }
            }
        }
        public async Task CreateAsync(FbController2 fbController)
        {
            fbController.AddParameter("@ARZU_A_AUSGANGSART", ARZU_A_AUSGANGSART);
            fbController.AddParameter("@ARZU_A_ZUBEHOERART", ARZU_A_ZUBEHOERART);
            fbController.AddParameter("@ARZU_B_NOTIZ", ARZU_B_NOTIZ);
            fbController.AddParameter("@ARZU_N_LASTUSER", ARZU_N_LASTUSER);

            string sql = @"INSERT INTO ARTIKELZUBEHOER 
(
ARZU_A_AUSGANGSART,
ARZU_A_ZUBEHOERART,
ARZU_B_NOTIZ,
ARZU_N_LASTUSER
) 
VALUES 
(
@ARZU_A_AUSGANGSART,
@ARZU_A_ZUBEHOERART,
@ARZU_B_NOTIZ,
@ARZU_N_LASTUSER
)";

            await fbController.QueryAsync(sql);


        }

        public static async Task DeleteAsync(string ausgangsartikel, string zubehörartikel, FbController2 fbController)
        {
            fbController.AddParameter("@AUSART", ausgangsartikel);
            fbController.AddParameter("@ZUART", zubehörartikel);

            await fbController.QueryAsync("DELETE FROM ARTIKELZUBEHOER WHERE ARZU_A_AUSGANGSART = @AUSART AND ARZU_A_ZUBEHOERART = @ZUART");
        }
    }
}
