﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class ArtikelOption
    {
        [CompareField("AROP_N_NR")]
        public int Id { get; set; }
        [CompareField("AROP_A_NAME")]
        public string Name { get; set; } = string.Empty;
        [CompareField("AROP_A_TYP")]
        public string Typ { get; set; } = "text";
        /// <summary>
        /// Gibt an, auf welches Datenbankfeld des Artikels sich diese Option bezieht.
        /// </summary>
        [CompareField("AROP_A_DBFELD")]
        public string? Datenbankfeld { get; set; } = string.Empty;
        /// <summary>
        /// Gibt den geringst möglichen Wert der Option an.
        /// <para>
        /// Diese Eigenschaft ist nur beim Typ "number" relevant.
        /// </para>
        /// </summary>
        [CompareField("AROP_N_MINVALUE")]
        public decimal MinValue { get; set; }
        /// <summary>
        /// Gibt den maximal möglichen Wert der Option an.
        /// <para>
        /// Diese Eigenschaft ist nur beim Typ "number" relevant.
        /// </para>
        /// </summary>
        [CompareField("AROP_N_MAXVALUE")]
        public decimal MaxValue { get; set; }
        [CompareField("AROP_N_ORDER")]
        public int SortOrder { get; set; }
        public List<ArtikelOptionValue> OptionValues { get; } = new List<ArtikelOptionValue>();
        [CompareField("AZUO_L_REQUIRED")]
        public bool IsRequired { get; set; }
    }
}
