﻿using System;

namespace WK5.Core.Models
{
    public record ArtikelAssoziation(string Artikelnummer, string Assoziation)
    {
        private string _artikelnummer = Artikelnummer.ToUpper() ?? throw new ArgumentNullException(nameof(Artikelnummer));
        private string _assoziation = Assoziation.ToUpper() ?? throw new ArgumentNullException(nameof(Assoziation));


        public string Artikelnummer
        {
            get => _artikelnummer;
            init => _artikelnummer = value?.ToUpper() ?? throw new ArgumentNullException(nameof(Artikelnummer));
        }

        public string Assoziation
        {
            get => _assoziation;
            init => _assoziation = value?.ToUpper() ?? throw new ArgumentNullException(nameof(Assoziation));
        }

    }
}
