﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;
using WK5.Core.OpenCart;

namespace WK5.Core.Models
{
    public class ArtikelAngebot
    {
        private bool _SolangeDerVorratReicht;

        public int ARAN_N_NR { get; set; }
        public string ARAN_A_ARTINR { get; set; } = String.Empty;
        public decimal ARAN_N_PREIS { get; set; }
        public DateTime ARAN_D_START { get; set; }
        public DateTime ARAN_D_ENDE { get; set; }
        public int ARAN_N_OPENCART_GRUPPE { get; set; }
        public int ARAN_N_PREISLISTE { get; set; }
        public bool SolangeDerVorratReicht
        {
            get
            {
                if (ARAN_D_ENDE == default)
                {
                    return true;
                }
                else
                {
                    return _SolangeDerVorratReicht;
                }
            }
            set
            {
                _SolangeDerVorratReicht = value;

                if (!_SolangeDerVorratReicht)
                {
                    if (ARAN_D_ENDE == default)
                    {
                        ARAN_D_ENDE = DateTime.Now.AddDays(14);
                    }
                }
                else
                {
                    ARAN_D_ENDE = default;
                }
            }
        }
        public static async IAsyncEnumerable<ArtikelAngebot> GetAngeboteAsync(string ARTI_A_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@ARAN_A_ARTINR", ARTI_A_NR);
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM WK5_ARTIKEL_ANGEBOTE WHERE UPPER(ARAN_A_ARTINR) = UPPER(@ARAN_A_ARTINR)");

            foreach (DataRow row in data.Rows)
            {
                if (row is not null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new ArtikelAngebot(), row);
                }
            }
        }

        public static async Task UpdateArtikelAngebotAsync(ArtikelAngebot angebot, FbController2 fbController)
        {
            string sql = @"UPDATE WK5_ARTIKEL_ANGEBOTE SET
ARAN_A_ARTINR = @ARAN_A_ARTINR,
ARAN_N_PREIS = @ARAN_N_PREIS,
ARAN_D_START= @ARAN_D_START,
ARAN_D_ENDE = @ARAN_D_ENDE,
ARAN_N_OPENCART_GRUPPE = @ARAN_N_OPENCART_GRUPPE,
ARAN_N_PREISLISTE = @ARAN_N_PREISLISTE
WHERE ARAN_N_NR = @ARAN_N_NR";

            fbController.AddParameter("@ARAN_A_ARTINR", angebot.ARAN_A_ARTINR);
            fbController.AddParameter("@ARAN_N_PREIS", angebot.ARAN_N_PREIS);
            fbController.AddParameter("@ARAN_D_START", angebot.ARAN_D_START);
            fbController.AddParameter("@ARAN_D_ENDE", angebot.ARAN_D_ENDE);
            fbController.AddParameter("@ARAN_N_OPENCART_GRUPPE", angebot.ARAN_N_OPENCART_GRUPPE);
            fbController.AddParameter("@ARAN_N_NR", angebot.ARAN_N_NR);
            fbController.AddParameter("@ARAN_N_PREISLISTE", angebot.ARAN_N_PREISLISTE);
            await fbController.QueryAsync(sql);
        }


        public static async Task<ArtikelAngebot> InsertArtikelAngebotAsync(ArtikelAngebot angebot, FbController2 fbController)
        {
            string sql = @"INSERT INTO WK5_ARTIKEL_ANGEBOTE
(ARAN_A_ARTINR, ARAN_N_PREIS, ARAN_D_START, ARAN_D_ENDE, ARAN_N_OPENCART_GRUPPE, ARAN_N_PREISLISTE)
VALUES
(@ARAN_A_ARTINR, @ARAN_N_PREIS, @ARAN_D_START, @ARAN_D_ENDE, @ARAN_N_OPENCART_GRUPPE, @ARAN_N_PREISLISTE)
RETURNING ARAN_N_NR";
            fbController.AddParameter("@ARAN_A_ARTINR", angebot.ARAN_A_ARTINR);
            fbController.AddParameter("@ARAN_N_PREIS", angebot.ARAN_N_PREIS);
            fbController.AddParameter("@ARAN_D_START", angebot.ARAN_D_START);
            fbController.AddParameter("@ARAN_D_ENDE", angebot.ARAN_D_ENDE);
            fbController.AddParameter("@ARAN_N_OPENCART_GRUPPE", angebot.ARAN_N_OPENCART_GRUPPE);
            fbController.AddParameter("@ARAN_N_PREISLISTE", angebot.ARAN_N_PREISLISTE);

            object? idObj = await fbController.FetchObjectAsync(sql);

            if (idObj is not null)
            {
                angebot.ARAN_N_NR = Convert.ToInt32(idObj);
            }

            return angebot;
        }

        public async Task DeleteAsync(FbController2 fbController)
        {
            string sql = "DELETE FROM WK5_ARTIKEL_ANGEBOTE WHERE ARAN_N_NR = @NR";
            fbController.AddParameter("@NR", ARAN_N_NR);

            await fbController.QueryAsync(sql);
        }
    }
}
