﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using TwinFinder.Matching;
using TwinFinder.Matching.Compare;
using TwinFinder.Matching.StringFuzzyCompare.AddressSpecific;
using TwinFinder.Matching.StringFuzzyCompare.Aggregators;

namespace WK5.Core.Models
{
    public class AnsprechpartnerLieferant
    {
        #region Datenbankfelder
        public int LIEP_N_LIEFNR { get; set; }
        public int LIEP_N_NR { get; set; }
        public string LIEP_A_NAME { get; set; } = String.Empty;
        public string? LIEP_A_BEREICH { get; set; }
        public string? LIEP_A_TELEFON { get; set; }
        public string? LIEP_A_HANDY { get; set; }
        public string? LIEP_A_TELEFAX { get; set; }
        public string? LIEP_A_EMAIL { get; set; }
        public string? LIEP_A_ADRESSTEXT { get; set; }
        public string? LIEP_A_ANREDE { get; set; }
        public string? LIEP_A_NOTIZ { get; set; }
        public bool LIEP_L_HAUPTPARTNER { get; set; }
        public DateTime LIEP_TIMESTAMP { get; set; }
        public int LIEP_N_LASTUSER { get; set; }
        #endregion


        /// <summary>
        /// Gibt eine Liste aller Ansprechpartner eines Lieferanten zurück
        /// </summary>
        /// <param name="LIEP_N_LIEFNR">Die Nummer des Lieferanten.</param>
        /// <returns>Liefert alle Ansprechpartner des Lieferanten als IEnumerable zurück.</returns>
        public static async IAsyncEnumerable<AnsprechpartnerLieferant> GetAnsprechpartnerAsync(int LIEP_N_LIEFNR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@LIEP_N_LIEFNR", LIEP_N_LIEFNR);
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM LIEF_PARTNER WHERE LIEP_N_LIEFNR = @LIEP_N_LIEFNR");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new AnsprechpartnerLieferant(), row);
            }
        }

   


        /// <summary>
        /// Versucht einen Ansprechpartner für einen Lieferanten anhand des Namens auszulesen
        /// </summary>
        /// <param name="LIEP_N_LIEFNR">Die ID des Lieferanten, für den wir den Ansprechpartner suchen</param>
        /// <param name="name">Der Name des Ansprechpartners</param>
        /// <returns>Gibt ein Objekt der Klasse <see cref="Ansprechpartner"/> zurück</returns>
        public static async Task<AnsprechpartnerLieferant?> GetAnsprechpartnerByNameAsync(int LIEP_N_LIEFNR, string? LIEP_A_NAME)
        {
            List<AnsprechpartnerLieferant> alle = await GetAnsprechpartnerAsync(LIEP_N_LIEFNR).ToListAsync();

            string explainPlan = "";
            float result = 0.0f;

            var record1 = new Dictionary<string, string>()
            {
                {"Name", LIEP_A_NAME ?? String.Empty }
            };

            var defGroup = new CompareDefinitionGroup()
            {
                Aggregator = new MaximumAggregator(),

                CompareDefinitions = new List<CompareDefinition>()
                {
                    new CompareDefinition()
                    {
                        Name = "AddressDefinition",
                        Aggregator = new AverageAggregator(),
                        CompareFields = new List<CompareField>()
                        {
                            new CompareField()
                            {
                                Name1 = "Name",
                                Name2 = "Name",
                                FuzzyComparer = new NameComparer()
                            }
                        }
                    }
                }
            };

            foreach (var partner in alle)
            {
                var record2 = new Dictionary<string, string>()
                {
                    {"Name", $"{partner.LIEP_A_NAME}" }
                };

                result = MatchingService.Instance.CompareRecords(record1, record2, defGroup, out explainPlan);

                if (result >= 95)
                {
                    return partner;
                }
            }


            return null;
        }

        public string GetName() => Regex.Replace($"{LIEP_A_NAME}", "  +/g", " ").Trim();
    }
}
