﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt eine Funktion eines Ansprechpartners dar.
    /// </summary>
    public class AnsprechpartnerFunktion
    {
        /// <summary>
        /// Ruft die eindeutige Id ab, oder legt diese fest.
        /// </summary>

        [CompareField("ANFU_N_ID")]
        public int Id { get; set; }
        /// <summary>
        /// Ruft die Bezeichnung der Funktion ab, oder legt diese fest.
        /// </summary>

        [CompareField("ANFU_A_BEZEICHNUNG")]
        public string Bezeichnung { get; set; } = string.Empty;
        /// <summary>
        /// Ruft alle Funktionen für Ansprechpartner ab.
        /// </summary>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public static async Task<List<AnsprechpartnerFunktion>> GetAnsprechpartnerFunktionenAsync(FbController2 fbController)
        {
            return await fbController.SelectDataAsync<AnsprechpartnerFunktion>("SELECT * FROM ANSPRECHPARTNER_FUNKTIONEN ORDER BY ANFU_A_BEZEICHNUNG");
        }

    }
}
