﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Anrede
    {
        #region Datenbankfelder
        /// <summary>
        /// Ruft die eigentliche Anrede ab.
        /// </summary>
        public string ANRE_A_ANREDE { get; private set; } = String.Empty;
        /// <summary>
        /// Liefert eine eindeutige ID zurück, mit der sich die Anrede eindeutig identifizieren lässt.
        /// </summary>
        public int ANRE_N_NR { get; private set; }
        /// <summary>
        /// Ruft den Zeitpunkt der letzten Änderung einer Anrede ab.
        /// </summary>
        public DateTime ANRE_TIMESTAMP { get; set; }
        /// <summary>
        /// Ruft die UserId des letzten Bearbeiters der Anrede ab.
        /// </summary>
        public int ANRE_N_LASTUSER { get; set; }
        #endregion
        /// <summary>
        /// Gibt alle in der Datenbank eingetragenen Anreden zurück
        /// </summary>
        /// <returns>Gibt ein Objekt der Klasse <see cref="List{T}"/> zurück wo T <see cref="Anrede"/> ist.</returns>
        public static async IAsyncEnumerable<Anrede> GetAnredenAsync(FbController2 fbController)
        {
            var data = await fbController.SelectDataAsync("SELECT * FROM ANREDEN ORDER BY ANRE_A_ANREDE");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Anrede(), row);
            }
        }
    }
}
