﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Runtime.CompilerServices;
using System.Threading;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt einen Ablehnungsgrund für ein Angebot dar.
    /// </summary>
    public class Ablehnungsgrund
    {
        private string _grund = string.Empty;

        [CompareField("ABGR_N_ID")]
        public int Id { get; set; }
        [CompareField("ABGR_A_GRUND")]
        public string Grund { get => _grund; set => _grund = value ?? string.Empty; }
        [CompareField("ABGR_N_LASTUSER")]
        public int LetzerBearbeiter { get; set; }
        [CompareField("ABGR_TIMESTAMP")]
        public DateTime Timestamp { get; set; }

        /// <summary>
        /// Gibt alle verfügbaren Ablehnungsgründe zurück.
        /// </summary>
        /// <param name="fbController"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public static async IAsyncEnumerable<Ablehnungsgrund> GetAblehnungsgründeAsync(FbController2 fbController, [EnumeratorCancellation] CancellationToken cancellationToken = default)
        {
            cancellationToken.ThrowIfCancellationRequested();
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM ABLEHNUNGSGRUENDE ORDER BY ABGR_A_GRUND", cancellationToken);

            foreach (DataRow row in data.Rows)
            {
                cancellationToken.ThrowIfCancellationRequested();
                yield return ObjectErweiterung.DataRowZuObjekt(new Ablehnungsgrund(), row);
            }
        }
    }
}
