﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt einen Abgang dar.
    /// </summary>
    public class Abgang
    {
        public int ARAB_N_NR { get; set; }
        public DateTime ARAB_D_DATUM { get; set; }
        public string ARAB_A_ARTIKEL { get; set; } = String.Empty;
        public decimal ARAB_N_MENGE { get; set; }
        public decimal ARAB_N_EINZELPREIS { get; set; }
        public int ARAB_N_CHARGE { get; set; }
        public string? ARAB_A_SN { get; set; }
        public int ARAB_N_KOSTENSTELL { get; set; }
        public string? ARAB_A_NOTIZ { get; set; }
        public int ARAB_N_AUNR { get; set; }
        public int ARAB_N_PROJEKTNR { get; set; }
        public int ARAB_N_RMANR { get; set; }
        public int ARAB_N_RMAPOS { get; set; }
        public int ARAB_N_SPERRUSERID { get; set; }
        public DateTime ARAB_TIMESTAMP { get; set; }
        public int ARAB_N_LASTUSER { get; set; }
        /// <summary>
        /// Lädt einen Abgang aus der Datenbank.
        /// </summary>
        /// <param name="abgangsnummer"></param>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public static async Task<Abgang?> GetAbgangAsync(int abgangsnummer, FbController2 fbController)
        {
            fbController.AddParameter("@ARAB_N_NR", abgangsnummer);
            var row = await fbController.SelectRowAsync("SELECT * FROM ABGAENGE WHERE ARAB_N_NR = @ARAB_N_NR");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Abgang(), row);
        }
    }
}
