﻿namespace WK5.Core
{
    /// <summary>
    /// Stellt eine generalisierte API-Response für einen Service dar.
    /// </summary>
    internal interface IApiResponse<T> where T : System.Enum
    {
        /// <summary>
        /// Ruft einen möglichen Status für die Buchungsanfrage ab, oder legt diesen fest.
        /// </summary>
        public T Status { get; set; }
        /// <summary>
        /// Ruft eine Message ab, oder legt diese fest.
        /// <para>
        /// Fehlermeldungen werden z.B. hier mit übergeben.
        /// </para>
        /// </summary>
        public string? Message { get; set; }
        /// <summary>
        /// Ruft ein zusätzliches Objekt ab, oder legt dieses fest.
        /// <para>
        /// Hier werden z.B. neue Buchungsdaten an das Front-End zurückgegeben, oder ggf. Exceptions an das Front-End übergeben
        /// </para>
        /// </summary>
        public object? Value { get; set; }
        /// <summary>
        /// Ruft einen Wert ab, der angibt, ob die Anfrage erfolgreich war, oder nicht.
        /// </summary>
        public bool Success { get; set; }

    }
}
