﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Email;

namespace WK5.Core
{
    /// <summary>
    /// Klasse ersetzt einen Herstellernamen, so das diese vereinheitlicht werden für alle Lieferanten
    /// Die Klasse wurde ausgelagert, damit diese nur einmal pro Programmstart die Liste einliest und nicht für jeden Artikel. 
    /// </summary>
    public class HerstellerErsetzen
    {
        private List<string[]> herstellernummerSubStitute = new List<string[]>();
        private Dictionary<string, string> NameSubStitute = new Dictionary<string, string>();
        private Dictionary<string, string> NameSubStituteStartsWith = new Dictionary<string, string>();
        private List<string[]> vpeStueckPreise_70003 = new List<string[]>();
        private List<string[]> vpeStueckPreise_70009 = new List<string[]>();
        private List<string[]> vpeStueckPreise_70014 = new List<string[]>();
        private List<string[]> vpeStueckPreise_70038 = new List<string[]>();
        private List<string[]> vpeStueckPreise_70150 = new List<string[]>();
        private List<string[]> vpeStueckPreise_70511 = new List<string[]>();
        private List<string[]> vpeStueckPreise_70944 = new List<string[]>();
        private List<string[]> vpeStueckPreise_71142 = new List<string[]>();
        private List<string[]> vpeStueckPreise_70037 = new List<string[]>();
        private HerstellerErsetzen()
        {

        }

        public static async Task<HerstellerErsetzen> CreateAsync()
        {
            HerstellerErsetzen ersetzenKlasse = new HerstellerErsetzen();
#if DEBUG
            string file = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "HerstellerNameSubStituteKarley.txt");
#else
            string file = Path.Combine(GlobalConfig.W4TmpFolder, "HerstellerNameSubStituteKarley.txt");
#endif
            if (File.Exists(file))
            {
                var fs = new FileStream(file, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                using StreamReader r = new StreamReader(fs, Encoding.Default);
                string? line;
                while ((line = r.ReadLine()) != null)
                {
                    string[] lineVals = line.ToUpper().Split(';');
                    if (lineVals.Length == 2)
                    {
                        if (!lineVals[0].StartsWith("//"))
                        {
                            try
                            {
                                ersetzenKlasse.NameSubStitute.Add(lineVals[0], lineVals[1]);
                            }
                            catch (Exception ex)
                            {
                                await EmailController.FehlerMailSendenAsync(
                                    betreff: "Fehler in HerstellerNameSubStituteKarley.txt",
                                    body: $"Vermutlich wurde mehrmals der selbe Key verwendet : {lineVals[0]} - {lineVals[1]}<br /><br />Fehlermeldung:<br />{ex.Message}"
                                );
                            }
                        }
                    }
                    else
                    {
                        ersetzenKlasse.NameSubStituteStartsWith.Add(lineVals[0], lineVals[1]);
                    }
                }
            }
            else
            {
                await EmailController.FehlerMailSendenAsync(
                    betreff: "Fehler in HerstellerErsetzen (FileIO)",
                    body: "HerstellerNameSubStituteKarley.txt wurde nicht gefunden."
                );

                throw new Exception("HerstellerNameSubStituteKarley.txt konnte nicht gefunden werden.");
            }

            await ersetzenKlasse.ReadHerstellerNummerSubstitueAsync();
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(70003, ersetzenKlasse.vpeStueckPreise_70003);
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(70009, ersetzenKlasse.vpeStueckPreise_70009);
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(70014, ersetzenKlasse.vpeStueckPreise_70014);
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(70037, ersetzenKlasse.vpeStueckPreise_70037);
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(70150, ersetzenKlasse.vpeStueckPreise_70150);
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(70511, ersetzenKlasse.vpeStueckPreise_70511);
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(70944, ersetzenKlasse.vpeStueckPreise_70944);
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(71142, ersetzenKlasse.vpeStueckPreise_71142);
            await ersetzenKlasse.ReadVpeStueckPreiseAsync(70038, ersetzenKlasse.vpeStueckPreise_70038);

            return ersetzenKlasse;
        }
        private async Task ReadVpeStueckPreiseAsync(int lieferantenId, List<string[]> list)
        {
#if DEBUG
            string file = Path.Combine(GlobalConfig.W4TmpFolderSrv01, $"{lieferantenId}_VPEStueck.txt");
#else
            string file = Path.Combine(GlobalConfig.W4TmpFolder, $"{lieferantenId}_VPEStueck.txt");
#endif

            var fs = new FileStream(file, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
            using StreamReader r = new StreamReader(fs, Encoding.Default);
            string? line;
            while ((line = r.ReadLine()) != null)
            {
                string[] lineVals = line.ToUpper().Split(';');

                if (lineVals.Length > 1 && !lineVals[0].StartsWith("//"))
                {
                    try
                    {
                        list.Add(new string[3] { lineVals[0], lineVals[1], lineVals[2] });
                    }
                    catch (Exception)
                    {
                        string fehler = "";

                        if (lineVals.Length < 3)
                        {
                            fehler = " Möglicher Fehler: Nicht genug Parameter, ; vergessen?";
                        }

                        await EmailController.FehlerMailSendenAsync(
                            betreff: $"{lieferantenId}_VPEStueck.txt",
                            body: $"Fehler bei Key : {lineVals[0]} - Bitte prüfen.{fehler}"
                        );
                    }
                }

            }

        }
        private async Task ReadHerstellerNummerSubstitueAsync()
        {
#if DEBUG
            string file = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "HerstellerNummerSubStitute.txt");
#else
            string file = Path.Combine(GlobalConfig.W4TmpFolder, "HerstellerNummerSubStitute.txt");
#endif
            if (File.Exists(file))
            {
                var fs = new FileStream(file, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                using StreamReader r = new StreamReader(fs, Encoding.Default);
                string? line;
                while ((line = r.ReadLine()) != null)
                {
                    string[] lineVals = line.ToUpper().Split(';');
                    if (lineVals.Length > 1)
                    {
                        if (!lineVals[0].StartsWith("//"))
                        {
                            try
                            {
                                herstellernummerSubStitute.Add(new string[3] { lineVals[0], lineVals[1], lineVals[2] });
                            }
                            catch (Exception)
                            {
                                await EmailController.FehlerMailSendenAsync(
                                    betreff: "Fehler in HerstellerNummerSubStitute.txt",
                                    body: $"Vermutlich wurde mehrmals der selbe Key verwendet : {lineVals[0]} - {lineVals[1]}"
                                );
                            }
                        }
                    }
                }
            }
            else
            {
                await EmailController.FehlerMailSendenAsync(betreff: "Fehler in HerstellerErsetzen (FileIO)", body: "HerstellerNameSubStituteKarley.txt wurde nicht gefunden.");

                throw new Exception("HerstellerNameSubStituteKarley.txt wurde nicht gefunden.");
            }
        }


        public string HerstellerNummerErsetzen(string hersteller, string herstellerNummer)
        {
            string neueHerstellerNummer = herstellerNummer.ToUpper();

            var substitutes = herstellernummerSubStitute.Where(x => x[0].ToUpper() == hersteller.ToUpper());

            foreach (string[] sub in substitutes)
            {
                neueHerstellerNummer = neueHerstellerNummer.Replace(sub[1], sub[2]);
            }

            return neueHerstellerNummer.TrimEnd();
        }
        public string GetHerstellerErsetzt(string hersteller)
        {

            string newName = hersteller.ToUpper();

            if (NameSubStitute.ContainsKey(newName))
            {
                newName = NameSubStitute[newName];
            }

            int Länge = 10;
            if (Länge != 0)
            {
                //Datalogic ADS
                newName = newName.Replace(" ", "");
                //DatalogicADS
                newName = newName.Substring(0, newName.Length >= Länge ? Länge : newName.Length);
                //DatalogicA
            }

            if (NameSubStitute.ContainsKey(newName))
            {
                newName = NameSubStitute[newName];
            }

            foreach (KeyValuePair<string, string> item in NameSubStituteStartsWith)
            {
                if (newName.Contains(item.Key))
                {
                    newName = item.Value;
                    break;
                }
            }

            return newName.ToUpper();


        }

        public bool IstHerstellerIngramm(List<string[]> hersteller, String HerstellerName)
        {
            foreach (string[] ingramm_vars in hersteller)
            {
                if (ingramm_vars[0].ToUpper() == HerstellerName.ToUpper())
                {
                    return true;
                }
            }
            return false;
        }

        public bool IstHerstellerKategorieErlaubIngramm(List<string[]> hersteller, String HerstellerName, String Kategorie)
        {
            if (!IstHerstellerIngramm(hersteller, HerstellerName))
            {
                return false;
            }

            foreach (string[] ingramm_vars in hersteller)
            {
                foreach (string ingramm_var in ingramm_vars)
                {
                    if (ingramm_var.ToUpper() == Kategorie.ToUpper())
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        public decimal GibStueckzahlVPEPreis(decimal preis, int lieferantenID, string artikelnummerLieferant)
        {
            decimal _preis = preis;
            List<string[]> vpeStueckPreise = lieferantenID switch
            {
                70003 => vpeStueckPreise_70003,
                70009 => vpeStueckPreise_70009,
                70014 => vpeStueckPreise_70014,
                70038 => vpeStueckPreise_70038,
                70150 => vpeStueckPreise_70150,
                70511 => vpeStueckPreise_70511,
                70944 => vpeStueckPreise_70944,
                71142 => vpeStueckPreise_71142,
                _ => new List<string[]>()
            };

            string[]? preisWerte = vpeStueckPreise.Where(x => x[0].ToUpper() == artikelnummerLieferant.ToUpper()).FirstOrDefault();

            if (preisWerte != null)
            {
                string preiswert = preisWerte[2].Replace(',', '.');
                if (preisWerte[1] == "*")
                {
                    if (decimal.TryParse(preiswert, NumberStyles.Any, CultureInfo.InvariantCulture, out decimal multiplikator))
                    {
                        _preis = preis * multiplikator;
                    }
                }
                else
                {
                    if (decimal.TryParse(preiswert, NumberStyles.Any, CultureInfo.InvariantCulture, out decimal teiler))
                    {
                        _preis = preis / teiler;
                    }
                }
            }
            return _preis;
        }

        public int GibMindestmenge(int lieferantenID, string artikelnummerLieferant)
        {
            List<string[]> vpeStueckPreise = lieferantenID switch
            {
                70003 => vpeStueckPreise_70003,
                70009 => vpeStueckPreise_70009,
                70014 => vpeStueckPreise_70014,
                70038 => vpeStueckPreise_70038,
                70150 => vpeStueckPreise_70150,
                70511 => vpeStueckPreise_70511,
                70944 => vpeStueckPreise_70944,
                71142 => vpeStueckPreise_71142,
                _ => new List<string[]>()
            };

            string[]? preisWerte = vpeStueckPreise.Where(x => x[0].ToUpper() == artikelnummerLieferant.ToUpper()).FirstOrDefault();



            if (preisWerte is null || preisWerte.Length < 3)
            {
                return 1;
            }

            if (preisWerte[1] == "/" && int.TryParse(preisWerte[2], out int menge))
            {
                return menge;
            }

            return 1;
        }

        /// <summary>
        /// Liest die IgnoreLieferantenArtikel.txt in eine Liste ein
        /// </summary>
        /// <returns>Gibt eine Liste <see cref="List{T}"/> wo T <see cref="String"/> ist zurück</returns>
        public List<string> GibIgnoreLieferantenArtikel(int lieferantennummer)
        {
#if DEBUG
            string file = Path.Combine(GlobalConfig.W4TmpFolderSrv01, $"{lieferantennummer}_IgnoreArtikel.txt");
#else
            string file = Path.Combine(GlobalConfig.W4TmpFolder, $"{lieferantennummer}_IgnoreArtikel.txt");
#endif

            List<string> retval = new List<string>();


            var fs = new FileStream(file, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
            using (StreamReader r = new StreamReader(fs, Encoding.Default))
            {
                string? line;
                while ((line = r.ReadLine()) != null)
                {
                    retval.Add(line);
                }
            }

            return retval;
        }


        /// <summary>
        /// Überprüft ob der Übergebene String in der IgnoreLieferantenArtikel.txt steht
        /// </summary>
        /// <param name="artikelnummer">Der zu überprüfende Artikel</param>
        /// <returns>Gibt einen <see cref="Boolean"/> zurück der bestimmt ob der Artikel in der Ignore Liste steht oder nicht</returns>
        public bool IsArtikelIgnored(string artikelnummer, int lieferantennummer)
        {
            List<string> ignoredArtikel = GibIgnoreLieferantenArtikel(lieferantennummer);
            return ignoredArtikel.Contains(artikelnummer);
        }

        
        /// <summary>
        /// Liest den Hersteller und zugehörige Produkttypen aus der IngramImportHersteller.txt aus
        /// </summary>
        /// <returns>Gibt eine Liste <see cref="List{T}"/> wobei T <see cref="string[]"/> zurück</returns>
        public async Task<List<string[]>> GibIngrammHerstellerUndKategorienAsync()
        {


#if DEBUG
            string file = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "IngramImportHersteller.txt");
#else
            string file = Path.Combine(GlobalConfig.W4TmpFolderSrv01, "IngramImportHersteller.txt");
#endif

            List<string[]> retval = new List<string[]>();

            var fs = new FileStream(file, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
            using StreamReader r = new StreamReader(fs, Encoding.Default);
            string? line;
            while ((line = r.ReadLine()) != null)
            {
                string[] lineVals = line.ToUpper().Split(';');

                if (lineVals.Length > 1)
                {
                    if (!lineVals[0].StartsWith("//"))
                    {
                        try
                        {
                            retval.Add(lineVals);
                        }
                        catch (Exception ex)
                        {
                            await EmailController.FehlerMailSendenAsync("Fehler in IngrammLieferant: readIngrammHerstellerUndKategorien", ex.Message);
                        }
                    }
                }
            }


            return retval;
        }
    }
}
