﻿using System;
using System.Configuration;
using System.Text;

namespace WK5.Core
{
    /// <summary>
    /// Stellt unsere Firmendaten dar.
    /// <para>
    /// Die Daten werden aus der appsettings.json geladen.
    /// </para>
    /// </summary>
    public class FirmenDaten
    {
        public string Firmenname { get; set; } = string.Empty;
        public string UstId { get; set; } = string.Empty;
        public string Steuernummer { get; set; } = string.Empty;
        public string Handelsregister { get; set; } = string.Empty;
        public string Telefon { get; set; } = string.Empty;
        public string Fax { get; set; } = string.Empty;
        public string Email { get; set; } = string.Empty;
        public string Url { get; set; } = string.Empty;
        public string Geschaeftsfuehrer { get; set; } = string.Empty;
        public string BIC { get; set; } = string.Empty;
        public string IBAN { get; set; } = string.Empty;
        public string Bankname { get; set; } = string.Empty;

        public Firmenanschrift Firmenanschrift { get; set; } = new Firmenanschrift();

        public string Impressum()
        {
            String ReturnText = "";
            ReturnText += "------------------------------------ \r\n"
                                        + Firmenname + " \r\n"
                                        + Firmenanschrift.Strasse + " \r\n"
                                        + Firmenanschrift.Land + "-" + Firmenanschrift.Postleitzahl + " " + Firmenanschrift.Ort + " \r\n"
                                        + "TEL: " + Telefon + " \r\n"
                                        + "FAX: " + Fax + " \r\n"
                                        + "Email: " + Email + " \r\n"
                                        + "URL: " + Url + " \r\n"
                                        + "Geschäftsführer: " + Geschaeftsfuehrer + " \r\n"
                                        + "Steuer-Nr: " + Steuernummer + " \r\n"
                                        + "UST-ID: " + UstId + " \r\n"
                                        + "-------------------------------------\r\n\r\n";
            return ReturnText;
        }

        public string ImpressumHTML()
        {
            string ReturnText = "";
            ReturnText += "<br><hr><img src='https://www.karley.de/image/catalog/karleyLogo.png' align=\"left\"><br>"
                + "<TABLE style=\"FONT-SIZE: 10px; FONT-FAMILY: Arial; WIDTH: 630px\" cellSpacing=0 cellPadding=0>"
                + "<TBODY><TR><TD colSpan=3><TABLE cellSpacing=0 cellPadding=0 width=630><TBODY><TR>"
                + "<TD class=bold style=\"BACKGROUND: #cccccc; PADDING-LEFT: 10px\" height=25 width=289>Herausgeber &amp; Firmensitz</TD>"
                + "<TD style=\"BORDER-RIGHT: #ffffff 1px solid\" width=1></TD><TD class=bold style=\"BACKGROUND: #cccccc; PADDING-LEFT: 10px\""
                + "height=25 width=290>Rechtl. Unternehmensangaben</TD></TR><TR>"
                + "<TD style=\"VERTICAL-ALIGN: top; PADDING-BOTTOM: 10px; PADDING-TOP: 10px; PADDING-LEFT: 10px; PADDING-RIGHT: 10px; FONT-SIZE: 10px; FONT-FAMILY: Arial;\">"
                + Firmenname + " <br>"
                + Firmenanschrift.Strasse + " <br>"
                + Firmenanschrift.Land + "-" + Firmenanschrift.Postleitzahl + " " + Firmenanschrift.Ort + " <br>"
                + "Telefon: " + Telefon + "<BR>Fax: " + Fax + "<BR>E-Mail: " + Email
                + "</P></TD><TD></TD>"
                + "<TD style=\"VERTICAL-ALIGN: top; PADDING-BOTTOM: 10px; PADDING-TOP: 10px; PADDING-LEFT: 10px; PADDING-RIGHT: 10px; FONT-SIZE: 10px; FONT-FAMILY: Arial;\">"
                + "<P>Geschäftsführung:" + Geschaeftsfuehrer + "<br>"
                + "Steuer-Nr: " + Steuernummer + " <br>"
                + "UST-ID: " + UstId + " <br></P></TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE><hr>";
            
            return ReturnText;
        }

        public string ImpressumHtmlDruckformulare()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("<table class=\"impressum\">");
            sb.AppendLine("\t<tbody>");
            sb.AppendLine("\t\t<tr>");
            sb.AppendLine("\t\t\t<td>");
            sb.AppendLine($"\t\t\t\t{Firmenname}<br />");
            sb.AppendLine($"\t\t\t\t{Firmenanschrift.Strasse}<br />");
            sb.AppendLine($"\t\t\t\t{Firmenanschrift.Land}-{Firmenanschrift.Postleitzahl} {Firmenanschrift.Ort}");
            sb.AppendLine("\t\t\t</td>");
            sb.AppendLine("\t\t\t<td>");
            sb.AppendLine($"\t\t\t\t{Handelsregister}<br />");
            sb.AppendLine($"\t\t\t\tUST-ID: {UstId}<br />");
            sb.AppendLine($"\t\t\t\tSteuernummer: {Steuernummer}");
            sb.AppendLine("\t\t\t</td>");
            sb.AppendLine("\t\t\t<td>");
            sb.AppendLine($"\t\t\t\t{Bankname}<br />");
            sb.AppendLine($"\t\t\t\tIBAN: {IBAN}<br />");
            sb.AppendLine($"\t\t\t\tBIC: {BIC}");
            sb.AppendLine("\t\t\t</td>");
            sb.AppendLine("\t\t\t<td>");
            sb.AppendLine($"\t\t\t\tTelefon: {Telefon}<br />");
            sb.AppendLine($"\t\t\t\tTelefax: {Fax}<br />");
            sb.AppendLine($"\t\t\t\tE-Mail: <a href=\"mailto:{Email}\">{Email}</a>");
            sb.AppendLine("\t\t\t</td>");
            sb.AppendLine("\t\t</tr>");
            sb.AppendLine("\t</tbody>");
            sb.AppendLine("</table>");




            return sb.ToString();
        }

        public string Bankdaten(string verwendungszweck, Sprache sprache = Sprache.Deutsch)
        {
            string bankdaten = "";
            switch (sprache)
            {
                case Sprache.Englisch:
                    bankdaten += "Account holder : Karley Deutschland GmbH";
                    bankdaten += $"{Environment.NewLine}Bank: {Bankname}";
                    bankdaten += $"{Environment.NewLine}BIC / SWIFT : {BIC}";
                    bankdaten += $"{Environment.NewLine}IBAN : {IBAN}";
                    bankdaten += $"{Environment.NewLine}Purpose: {verwendungszweck}";
                    break;
                case Sprache.Deutsch:
                    bankdaten += "Kontoinhaber : Karley Deutschland GmbH";
                    bankdaten += $"{Environment.NewLine}Bank: {Bankname}";
                    bankdaten += $"{Environment.NewLine}BIC / SWIFT : {BIC}";
                    bankdaten += $"{Environment.NewLine}IBAN : {IBAN}";
                    bankdaten += $"{Environment.NewLine}Verwendungszweck : {verwendungszweck}";
                    break;
                default:
                    break;
            }


            return bankdaten;
        }

        public enum Sprache
        {
            Englisch,
            Deutsch
        }
    }

    public class Firmenanschrift
    {
        public string Strasse { get; set; } = string.Empty;
        public string Land { get; set; } = string.Empty;
        public string Postleitzahl { get; set; } = string.Empty;
        public string Ort { get; set; } = string.Empty;
    }

}
