﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Threading.Tasks;
using WK5.Core.Email;

namespace WK5.Core
{
    /// <summary>
    /// Die alte FileIO Klasse von ArtikelUpdateOpencart. 1:1 Kopie.
    /// </summary>
    public static class FileIO
    {
        /// <summary>
        /// Gib z.B. Artikelnummern aus einer Liste aus. So können z.B. gesperrte Artikel in Textdateien ausgelagert werden.
        /// </summary>
        /// <param name="datei"></param>
        /// <returns>Gibt eine List (ToUpper) mit den Werten der Textdatei zurück</returns>
        public static async Task<List<string>> LeseListe(string datei)
        {
            List<string> ReadList = new List<string>();

            if (File.Exists(datei))
            {
                var fs = new FileStream(datei, FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                using StreamReader r = new StreamReader(fs);
                string? line;
                while ((line = r.ReadLine()) != null)
                {
                    if (!(line.StartsWith("//") && line.EndsWith("//")))
                    {
                        ReadList.Add(line.Trim().ToUpper());
                    }
                }
            }
            else
            {
                await EmailController.FehlerMailSendenAsync(
                    betreff: "Fehler in LeseListe (FileIO)",
                    body: $"{datei} wurde nicht gefunden."
                );

                throw new Exception($"Datei {datei} konnte nicht gefunden werden.");
            }

            return ReadList;
        }

    }
}
