﻿using System.Xml.Serialization;

namespace WK5.Core
{
    /// <summary>
    /// Alle verfügbaren Belegtypen der WK5
    /// </summary>
    public enum BelegTyp
    {
        [XmlEnum("RE")]
        Rechnung,
        [XmlEnum("AU")]
        Auftrag,
        [XmlEnum("LS")]
        Lieferschein,
        [XmlEnum("GU")]
        Gutschrift,
        [XmlEnum("AN")]
        Angebot
    }

    /// <summary>
    /// Alle möglichen Arten, bei denen ein Paket eingetragen werden kann.
    /// </summary>
    public enum PaketTyp
    {
        Kunde,
        Lieferant,
        Angebot,
        Auftrag,
        Lieferschein,
        Rechnung,
        RMA
    }

    /// <summary>
    /// Definiert 0-80 können alles Kontaktarten sein, 80+ Sind alles Programm Arten
    /// </summary>
    public enum KundenkontaktArten
    {
        Telefon = 0,
        Fax = 1,
        EMail = 2,
        VertreterBesuch = 3,
        Brief = 4,
        Technikservice = 5,
        Notiz = 6,
        Wartung = 7,
        MailingKundeEnde = 88,
        PaymentReminder = 89,
        SoftwarefehlerPaymentReminder = 90,
        AbrufReminder = 91,
        Reminder = 99

    }
    /// <summary>
    /// Alle möglichen Modi zur Darstellung von Artikel Verbrauchsdaten
    /// </summary>
    public enum ArtikelVerbrauchsdatenModus
    {
        Menge,
        Umsatz,
        Ertrag
    }
    /// <summary>
    /// Alle möglichen Typen eines Liefernatenkontakts
    /// </summary>
    public enum LieferantenKontaktTyp
    {
        Alle = 0,
        AuftragsbestätigungÜberfällig = 1,
        LieferterminÜberfällig = 2,
        VersendetAberLieferterminÜberfällig = 3,
        Telefon = 4,
        Fax = 5,
        Email = 6,
        Vertreterbesuch = 7,
        Brief = 8,
        Technikservice = 9,
        Buchhaltung = 10
    }
}
