﻿using System;
using System.IO;
using System.Xml.Serialization;

namespace WK5.Core.Email.Texte
{
    [Serializable]
    public class LieferantenReminderTexte
    {
        /// <summary>
        /// Ruft den Betreff für die E-Mail an den Lieferanten ab.
        /// <para>
        /// Dieser Text wird nur verwendet bei den ersten zwei Kontaktversuchen.
        /// </para>
        /// <para>
        /// {LIEFERANT} wird durch den Namen des Lieferanten ersetzt.
        /// </para>
        /// </summary>
        public string EmailBetreffLieferant { get; set; } = String.Empty;
        /// <summary>
        /// Ruft den Inhalt für die E-Mail an den Lieferanten ab.
        /// <para>
        /// Dieser Text wird nur verwendet bei den ersten zwei Kontaktversuchen.
        /// </para>
        /// </summary>
        public string EmailBodyLieferant { get; set; } = String.Empty;
        /// <summary>
        /// Ruft den Betreff für die E-Mail an den Vertrieb ab.
        /// <para>
        /// Dieser Text wird nur verwendet ab dem dritten Kontaktversuch
        /// </para>
        /// </summary>
        public string EmailBetreffVertrieb { get; set; } = String.Empty;
        /// <summary>
        /// Ruft den Inhalt für die E-Mail an den Vertrieb ab.
        /// <para>
        /// Dieser Text wird nur verwendet ab dem dritten Kontaktversuch
        /// </para>
        /// </summary>
        public string EmailBodyVertrieb { get; set; } = String.Empty;
        /// <summary>
        /// Ruft den Text für das Notizfeld in WK5_LIEFERANTENKONTAKTE ab.
        /// </summary>
        public string LieferantenKontaktNotiz { get; set; } = String.Empty;
        /// <summary>
        /// Ruft den Text für das Feld BCNG_A_WERTALT der Tabelle BELEG_CHANGE ab.
        /// <para>
        /// Dieser Wert darf nicht länger als 40 Zeichen sein.
        /// </para>
        /// </summary>
        public string BestellungHistorieAlt { get; set; } = String.Empty;
        /// <summary>
        /// Ruft den Text für das Feld BCNG_A_WERTNEU der Tabelle BELEG_CHANGE ab.
        /// <para>
        /// Dieser Wert darf nicht länger als 40 Zeichen sein.
        /// </para>
        /// </summary>
        public string BestellungHistorieNeu { get; set; } = String.Empty;

        public static LieferantenReminderTexte? LoadText(string filename)
        {
            if (!File.Exists(filename))
            {
                throw new FileNotFoundException($"Die Datei {filename} existiert nicht.");
            }
            object? returnObject;
            XmlSerializer serializer = new XmlSerializer(typeof(LieferantenReminderTexte));
            using (StreamReader reader = new StreamReader(filename))
            {
                returnObject = serializer.Deserialize(reader);
            }

            return returnObject is null
                ? null
                : (LieferantenReminderTexte)returnObject;
        }

        public void SerializeText(string filename)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(LieferantenReminderTexte));
            using StreamWriter writer = new StreamWriter(filename);
            serializer.Serialize(writer, this);

        }
    }
}
