﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Email.Provider
{
    /// <summary>
    /// Eine Standardisierte Schnittstelle zwischen dem EmailController und den verschieden MTA (Mail-Transfer-Agents)
    /// </summary>
    public interface IMailProvider
    {
        /// <summary>
        /// Versendet eine Email
        /// </summary>
        /// <param name="absender">Der Absender von dem die Email gesendet wurde</param>
        /// <param name="empfänger">Eine Liste aus Email Adressen mit allen Empfängern der Email</param>
        /// <param name="betreff">Der Betreff der Email</param>
        /// <param name="body">Der Inhalt der Email</param>
        /// <param name="html">Gibt an ob die Email aus HTML besteht oder nicht</param>
        /// <param name="anhänge">Eine Liste der Anhänge die mit übertragne werden sollen</param>
        /// <param name="bcc">Eine Liste aus Email Adressen die im Blind Carbon Copy stehen sollen</param>
        /// <param name="cc">Eine Liste aus Email Adressen die im Carbon Copy stehen sollen</param>
        /// <returns>Gibt eine <see cref="EmailResponse"/> zurück die indiziert ob der Email Versand erfolgreich war oder nicht</returns>
        EmailResponse Senden(EmailAbsender absender, List<string> empfänger, string betreff, string body, bool html = true, List<EmailAnhang>? anhänge = null, List<string>? bcc = null, List<string>? cc = null);
    }
}
