﻿using iText.Html2pdf;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Drucken.Briefe;
using WK5.Core.Models;

namespace WK5.Core.Drucken.RMAS.RmaVersandbelegLieferant
{

    public class PrintRmaVersandbelegLieferant : PrintBase
    {
        private readonly DruckRma _rma;
        private readonly BriefRegelsatz _regeln;
        private readonly BriefAnschrift _lieferanschrift;
        private readonly BriefAnschrift _anschrift;


        private PrintRmaVersandbelegLieferant(DruckRma rma, BriefRegelsatz regeln)
        {
            _layoutFile = "RmaVersandbelegLieferant.html";
            _template = String.Empty;
            _rma = rma;
            _regeln = regeln;
            _lieferanschrift = _rma.GetVersandAnschriftFürLieferant();
            _anschrift = _rma.GetAnschriftLieferant();
        }
        public static async Task<PrintRmaVersandbelegLieferant> CreateAsync(DruckRma rma, BriefRegelsatz regeln)
        {

            var myClass = new PrintRmaVersandbelegLieferant(rma, regeln);
            await myClass.InitializeAsync();
            return myClass;
        }
        public override string Print(string speicherpfad)
        {
            string filename = $"RMA_{_rma.Id}_VERSAND_LF.pdf";

#if CREATE_PREVIEW_HTML
            File.WriteAllText(Path.Combine(speicherpfad, $"RMA_{_rma.Id}_VERSAND_LF.html"), _template);
#endif
            byte[] byteArray = Encoding.UTF8.GetBytes(_template);
            MemoryStream stream = new MemoryStream(byteArray);
            ConverterProperties converterProperties = new ConverterProperties()
                .SetBaseUri(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, LAYOUT_PATH));

            string fullPath = Path.Combine(speicherpfad, filename);
            if (File.Exists(fullPath))
            {
                File.Delete(fullPath);
            }

            HtmlConverter.ConvertToPdf(stream, new FileStream(fullPath, FileMode.OpenOrCreate, FileAccess.ReadWrite, FileShare.None), converterProperties);

            return fullPath;
        }

        protected override string GenerateDisplayCss()
        {
            StringBuilder cssBuilder = new StringBuilder();
            cssBuilder.AppendLine("<style>");



            if (!_regeln.ShowFooter)
            {
                cssBuilder.AppendLine("\t#footer {");
                //cssBuilder.AppendLine("\t\tdisplay: none;");
                cssBuilder.AppendLine("\t\tvisibility: hidden;");
                cssBuilder.AppendLine("\t\topacity: 0;");
                cssBuilder.AppendLine("\t\tcolor: rgba(0,0,0,0);");
                cssBuilder.AppendLine("\t\ttransform: scale(0);");
                cssBuilder.AppendLine("\t}");
            }

            if (!_regeln.ShowHeader)
            {
                cssBuilder.AppendLine("\t.karley-header {");
                //cssBuilder.AppendLine("\t\tdisplay: none;");
                cssBuilder.AppendLine("\t\tvisibility: hidden;");
                cssBuilder.AppendLine("\t\topacity: 0;");
                cssBuilder.AppendLine("\t\tcolor: rgba(0,0,0,0);");
                cssBuilder.AppendLine("\t\ttransform: scale(0);");
                cssBuilder.AppendLine("\t}");
            }

            if (!_regeln.ShowAdresszeileLand)
            {
                cssBuilder.AppendLine("\t.display-empfaenger-land{");
                cssBuilder.AppendLine("\t\tdisplay: none;");
                cssBuilder.AppendLine("\t}");
            }

            if (!_regeln.ShowAdresszeile2)
            {
                cssBuilder.AppendLine("\t.display-addresszeile2{");
                cssBuilder.AppendLine("\t\tdisplay: none;");
                cssBuilder.AppendLine("\t}");
            }

            if (!_regeln.ShowAdresszeile3)
            {
                cssBuilder.AppendLine("\t.display-addresszeile3{");
                cssBuilder.AppendLine("\t\tdisplay: none;");
                cssBuilder.AppendLine("\t}");
            }

            if (!_regeln.ShowAdresszeile4)
            {
                cssBuilder.AppendLine("\t.display-addresszeile4{");
                cssBuilder.AppendLine("\t\tdisplay: none;");
                cssBuilder.AppendLine("\t}");
            }

            cssBuilder.AppendLine("</style>");

            return cssBuilder.ToString();
        }

        protected override async Task InitializeAsync()
        {
            string layoutPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, LAYOUT_PATH, _layoutFile);
            _template = await File.ReadAllTextAsync(layoutPath);
            SetRegeln();
            _template = await SetTemplateVariables();
        }

        protected override Task InitializeAsync(FbController2 fbController)
        {
            throw new NotImplementedException();
        }

        protected override void SetRegeln()
        {
            _regeln.ShowAdresszeileLand = _anschrift.Land != "DE";
            _regeln.ShowAdresszeile2 = !String.IsNullOrWhiteSpace(_anschrift.Adresszeile2);
            _regeln.ShowAdresszeile3 = !String.IsNullOrWhiteSpace(_anschrift.Adresszeile3);
            _regeln.ShowAdresszeile4 = !String.IsNullOrWhiteSpace(_anschrift.Adresszeile4);
        }

        protected override async Task<string> SetTemplateVariables()
        {

            StringBuilder posBuilder = new StringBuilder();

            posBuilder.AppendLine("<tr>");

            // Artikelnummer + Bezeichnung
            posBuilder.AppendLine("\t<td>");
            posBuilder.AppendLine($"\t\t<span class=\"font-weight-bold\">");
            posBuilder.AppendLine($"\t\t\t{_rma.Artikelnummer}");
            posBuilder.AppendLine($"\t\t</span>");
            posBuilder.AppendLine($"\t\t<div class=\"position-bezeichnung\">");
            posBuilder.AppendLine($"\t\t\t{_rma.GetBezeichnung()}");
            posBuilder.AppendLine($"\t\t</div>");
            posBuilder.AppendLine($"\t\t<br />");

            posBuilder.AppendLine($"\t\t<div class=\"fehler-bezeichnung\">");
            posBuilder.AppendLine($"\t\t\t<span class=\"font-weight-bold\">");
            posBuilder.AppendLine($"\t\t\t\tFehlerbezeichnung:");
            posBuilder.AppendLine($"\t\t\t</span>");
            posBuilder.AppendLine($"\t\t\t{_rma.FehlerangabeLieferant}");
            posBuilder.AppendLine($"\t\t</div>");

            posBuilder.AppendLine($"\t\t<div class=\"wareneingang\">");
            posBuilder.AppendLine($"\t\t\t<span class=\"font-weight-bold\">");
            posBuilder.AppendLine($"\t\t\t\tGeliefert am::");
            posBuilder.AppendLine($"\t\t\t</span>");
            posBuilder.AppendLine($"\t\t\t{_rma.ZugangDatum.ToShortDateString()}");
            posBuilder.AppendLine($"\t\t</div>");

            if (!String.IsNullOrWhiteSpace(_rma.ZugangLieferscheinNummer))
            {

                posBuilder.AppendLine($"\t\t<div class=\"ihre-lieferscheinnummer\">");
                posBuilder.AppendLine($"\t\t\t<span class=\"font-weight-bold\">");
                posBuilder.AppendLine($"\t\t\t\tIhre Lieferscheinnummer:");
                posBuilder.AppendLine($"\t\t\t</span>");
                posBuilder.AppendLine($"\t\t\t{_rma.ZugangLieferscheinNummer} vom {_rma.ZugangLieferscheinDatum.ToShortDateString()}");
                posBuilder.AppendLine($"\t\t</div>");
            }

            if (!String.IsNullOrWhiteSpace(_rma.ZugangRechnungsNummer))
            {
                posBuilder.AppendLine($"\t\t<div class=\"ihre-rechnungsnummer\">");
                posBuilder.AppendLine($"\t\t\t<span class=\"font-weight-bold\">");
                posBuilder.AppendLine($"\t\t\t\tIhre Rechnungsnummer:");
                posBuilder.AppendLine($"\t\t\t</span>");
                posBuilder.AppendLine($"\t\t\t{_rma.ZugangRechnungsNummer} vom {_rma.ZugangRechnungsDatum.ToShortDateString()}");
                posBuilder.AppendLine($"\t\t</div>");
            }


            posBuilder.AppendLine("\t</td>");


            // Seriennummer
            posBuilder.AppendLine("\t<td>");
            posBuilder.AppendLine($"\t\t{_rma.Seriennummer}");
            posBuilder.AppendLine("\t</td>");


            // Seriennummer
            posBuilder.AppendLine("\t<td>");
            posBuilder.AppendLine($"\t\t{_rma.Menge}");
            posBuilder.AppendLine("\t</td>");



            posBuilder.AppendLine("</tr>");

            StringBuilder lieferanschriftBuilder = new StringBuilder();

            lieferanschriftBuilder.AppendLine($"{_lieferanschrift.Adresszeile1}<br />");

            if (!String.IsNullOrWhiteSpace(_lieferanschrift.Adresszeile2))
            {
                lieferanschriftBuilder.AppendLine($"{_lieferanschrift.Adresszeile2}<br />");
            }

            if (!String.IsNullOrWhiteSpace(_lieferanschrift.Adresszeile3))
            {
                lieferanschriftBuilder.AppendLine($"{_lieferanschrift.Adresszeile3}<br />");
            }

            if (!String.IsNullOrWhiteSpace(_lieferanschrift.Adresszeile4))
            {
                lieferanschriftBuilder.AppendLine($"{_lieferanschrift.Adresszeile4}<br />");
            }

            lieferanschriftBuilder.AppendLine($"{_lieferanschrift.Strasse}<br />");
            lieferanschriftBuilder.AppendLine($"{_lieferanschrift.Postleitzahl} {_lieferanschrift.Ort}<br />");
            lieferanschriftBuilder.AppendLine($"{_lieferanschrift.Land}");




            _template = _template
                .Replace("{{ ABS_FIRMA }}", GlobalConfig.Configuration.FirmenDaten.Firmenname)
                .Replace("{{ ABS_STRASSE }}", GlobalConfig.Configuration.FirmenDaten.Firmenanschrift.Strasse)
                .Replace("{{ ABS_LAND }}", GlobalConfig.Configuration.FirmenDaten.Firmenanschrift.Land)
                .Replace("{{ ABS_PLZ }}", GlobalConfig.Configuration.FirmenDaten.Firmenanschrift.Postleitzahl)
                .Replace("{{ ABS_ORT }}", GlobalConfig.Configuration.FirmenDaten.Firmenanschrift.Ort)
                .Replace("{{ DISPLAY_CSS }}", GenerateDisplayCss())
                .Replace("{{ IMPRESSUM }}", GlobalConfig.Configuration.FirmenDaten.ImpressumHtmlDruckformulare())
                .Replace("{{ RMA_NUMMER }}", _rma.Id.ToString())
                .Replace("{{ ADDRESSZEILE1 }}", _anschrift.Adresszeile1)
                .Replace("{{ ADDRESSZEILE2 }}", _anschrift.Adresszeile2)
                .Replace("{{ ADDRESSZEILE3 }}", _anschrift.Adresszeile3)
                .Replace("{{ ADDRESSZEILE4 }}", _anschrift.Adresszeile4)
                .Replace("{{ EMP_STRASSE }}", _anschrift.Strasse)
                .Replace("{{ EMP_LAND }}", _anschrift.Land)
                .Replace("{{ EMP_PLZ }}", _anschrift.Postleitzahl)
                .Replace("{{ EMP_ORT }}", _anschrift.Ort)
                .Replace("{{ LIEFERSCHEINNUMMER }}", _rma.LieferscheinNummer.ToString())
                .Replace("{{ DATUM }}", _rma.RücksendungAnLieferantDatum.ToShortDateString())
                .Replace("{{ LIEFERANTNUMMER }}", _rma.LieferantId.ToString())
                .Replace("{{ FIRMENNAME }}", GlobalConfig.Configuration.FirmenDaten.Firmenname)
                .Replace("{{ POSITIONEN }}", posBuilder.ToString())
                .Replace("{{ RMA_NUMMER_LIEFERANT }}", _rma.RmaNummerLieferant)
                .Replace("{{ LIEFERANSCHRIFT }}", lieferanschriftBuilder.ToString())
                ;

            return await Task.FromResult(_template);
        }
    }
}
