﻿using KarleyLibrary.Erweiterungen;
using Microsoft.JSInterop;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using System.Runtime.Versioning;
using System.Threading.Tasks;
using WK5.Core.Basis.Erweiterungen;

namespace WK5.Core.Drucken
{
    [SupportedOSPlatform("windows")]
    public static class PrintEtikett
    {
        /// <summary>
        /// Druckt ein Etikett für eine Artikelnummer
        /// </summary>
        /// <param name="artikelnummer"></param>
        public static void Print(string artikelnummer)
        {
            var writer = new ZXing.Windows.Compatibility.BarcodeWriter()
            {
                Format = ZXing.BarcodeFormat.DATA_MATRIX
            };

            var barcode = writer.Write(artikelnummer);
            Bitmap etikett = new Bitmap(415, 207);

            using (Graphics g = Graphics.FromImage(etikett))
            {
                g.CompositingQuality = CompositingQuality.HighQuality;
                g.InterpolationMode = InterpolationMode.High;
                g.SmoothingMode = SmoothingMode.AntiAlias;
                g.PixelOffsetMode = PixelOffsetMode.HighQuality;
                barcode = barcode.ResizeImage(150, 150);
                g.DrawImage(barcode, new Point((etikett.Width / 2) - (barcode.Width / 2), 10));

                string tmpArtikelnummer = artikelnummer.Length > 27 ? artikelnummer[0..27] : artikelnummer;
                Font font = new Font("Printer Display Font 1", 15f);
                SizeF textSize = g.MeasureString(tmpArtikelnummer, font);


                // Resize text to fit on Bitmap
                while (textSize.Width > (etikett.Width - 10) || textSize.Height > etikett.Height)
                {
                    font = new Font(font.FontFamily, font.Size - 0.1f, font.Style, font.Unit);
                    textSize = g.MeasureString(tmpArtikelnummer, font);
                }

                float xText = (etikett.Width / 2) - (textSize.Width / 2);
                g.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAlias;
                g.DrawString(tmpArtikelnummer, font, new SolidBrush(Color.Black), new PointF(xText, 165));
            }


            Printer.Print(etikett.ImageToByte(), GlobalConfig.GetArtikeletikettenPrinter());
            etikett.Save(Path.Combine(GlobalConfig.Configuration.OutputPfad, $"{artikelnummer}.png"));
        }
        /// <summary>
        /// Druckt ein Etikett für eine Artikelnummer und gibt noch zusätlich per Javascript eine Toastbenachrichtigung zurück.
        /// </summary>
        /// <param name="artikelnummer"></param>
        /// <param name="jsRuntime"></param>
        /// <returns></returns>
        public static async Task Print(string artikelnummer, IJSRuntime jsRuntime)
        {
            PrintEtikett.Print(artikelnummer);
            await jsRuntime.ShowToast(ToastType.success, "Etikett erfolgreich gedruckt");
        }
    }
}
