﻿using iText.Layout.Element;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Drucken.Briefe
{
    /// <summary>
    /// Bündelt die Daten die an die PrintBrief Klassen übergeben werden sollen
    /// </summary>
    public class BriefView
    {
        public BriefAbsender? Absender { get; set; }

        public BriefEmpfänger? Empfänger { get; set; }

        public DateTime Datum { get; set; }


        /// <summary>
        /// Der Betreff des Brief
        /// </summary>
        public string Betreff { get; set; }

        /// <summary>
        /// Der Inhalt des Brief
        /// </summary>
        public string Inhalt { get; set; }

        private string[] postVermerk = new string[3];

        /// <summary>
        /// Der Postvermerk der oberhalb der Adresse angezeigt werden soll. Array darf nur Indizes von 0-2 haben
        /// </summary>
        public string[] PostVermerk
        {
            get { return postVermerk; }
            set
            {
                if (value.Length < 3)
                {
                    postVermerk = value;
                }
                else
                {
                    postVermerk = value.Take(3).ToArray();
                }
            }
        }


        /// <summary>
        /// Legt fest ob Falz- und Lochmarken angezeigt werden sollen. FUNKTIONIERT AKTUELL NOCH NICHT
        /// </summary>
        public bool DisplayMarken { get; set; }

        /// <summary>
        /// Erstellt ein neues Objekt der Klasse BriefView das an einen Kunden versendet werden soll        
        /// </summary>
        /// <param name="kunde">Der Kunde der den Brief erhalten soll</param>
        /// <param name="betreff">Der Betreff der in dem Brief stehen soll</param>
        /// <param name="inhalt">Der Inhalt des Brief</param>
        public BriefView(string betreff, string inhalt)
        {
            this.Betreff = betreff;
            this.Inhalt = inhalt;
        }



        /// <summary>
        /// Legt die Postvermerke fest. Das vermerk Array sollte nur Indizes von 0-2 haben
        /// </summary>
        /// <param name="vermerk">Die Vermerke die eingetragen werden sollen</param>
        public void SetPostvermerk(params string[] vermerk) => this.PostVermerk = vermerk;

        /// <summary>
        /// Legt fest ob die Falz- und Lochmarken angezeigt werden sollen
        /// </summary>
        /// <param name="show">Gibt an ob die Marken angezeigt werden sollen</param>        
        public void ShowMarken(bool show) => this.DisplayMarken = show;

        public async Task<BriefView> SetAdresse(Lieferanschrift? anschrift)
        {
            if (anschrift is null)
                return this;

            if (this.Empfänger is null)
                this.Empfänger = new BriefEmpfänger();

            using FbController2 fbController = new FbController2();
            Land? land = await Land.GetLandAsync(anschrift.KULA_A_LAND, fbController);

            this.Empfänger.Firma = anschrift.KULA_A_NAME1 ?? String.Empty; ;
            if (land is not null)
                this.Empfänger.Land = land;
            this.Empfänger.Ort = anschrift.KULA_A_ORT ?? String.Empty; ;
            this.Empfänger.Postleitzahl = anschrift.KULA_A_PLZ ?? String.Empty; ;
            this.Empfänger.Strasse = anschrift.KULA_A_STRASSE ?? String.Empty; ;
            this.Empfänger.Firma2 = anschrift.KULA_A_NAME2 ?? String.Empty;
            return this;
        }

        public async Task<BriefView> SetAdresse(Rechnungsanschrift? anschrift)
        {
            if (anschrift is null)
                return this;

            if (this.Empfänger is null)
                this.Empfänger = new BriefEmpfänger();

            using FbController2 fbController = new FbController2();
            Land? land = await Land.GetLandAsync(anschrift.KURE_A_LAND, fbController);

            this.Empfänger.Firma = anschrift.KURE_A_NAME1 ?? String.Empty; ;
            if (land is not null)
                this.Empfänger.Land = land;
            this.Empfänger.Ort = anschrift.KURE_A_ORT ?? String.Empty; ;
            this.Empfänger.Postleitzahl = anschrift.KURE_A_PLZ ?? String.Empty; ;
            this.Empfänger.Strasse = anschrift.KURE_A_STRASSE ?? String.Empty; ;
            this.Empfänger.Firma2 = anschrift.KURE_A_NAME2 ?? String.Empty;
            return this;
        }

        public async Task<BriefView> SetEmpfängerAsync(Kunde? kunde)
        {
            if (kunde == null)
            {
                return this;
            }

            if (this.Empfänger == null)
            {
                this.Empfänger = new BriefEmpfänger();
            }

            using FbController2 fbController = new FbController2();
            this.Empfänger.Firma = kunde.KUND_A_NAME1;
            this.Empfänger.Land = await Land.GetLandAsync(kunde.KUND_A_LAND, fbController);
            this.Empfänger.Ort = kunde.KUND_A_ORT ?? String.Empty; ;
            this.Empfänger.Postleitzahl = kunde.KUND_A_PLZ;
            this.Empfänger.Strasse = kunde.KUND_A_STRASSE ?? String.Empty;
            this.Empfänger.Firma2 = kunde.KUND_A_NAME2 ?? String.Empty;
            return this;
        }

        public async Task<BriefView> SetEmpfängerAsync(Lieferant? lieferant)
        {
            if (lieferant == null)
            {
                return this;
            }

            if (this.Empfänger == null)
            {
                this.Empfänger = new BriefEmpfänger();
            }

            using FbController2 fbController = new FbController2();

            this.Empfänger.Firma = lieferant.LIEF_A_NAME1;
            this.Empfänger.Land = await Land.GetLandAsync(lieferant.LIEF_A_LAND, fbController);
            this.Empfänger.Ort = lieferant.LIEF_A_ORT ?? String.Empty;
            this.Empfänger.Postleitzahl = lieferant.LIEF_A_PLZ ?? String.Empty;
            this.Empfänger.Strasse = lieferant.LIEF_A_STR ?? String.Empty;
            this.Empfänger.Firma2 = lieferant.LIEF_A_NAME2 ?? String.Empty;
            return this;
        }

        public async Task<BriefView> SetEmpfängerAsync(Ansprechpartner partner)
        {
            if (partner is null)
            {
                return this;
            }

            if (Empfänger is null)
            {
                Empfänger = new BriefEmpfänger();
            }

            Kunde? k = await Kunde.GetKundeAsync(partner.PART_A_KUNDNR);
            if (k is not null)
            {
                await SetEmpfängerAsync(k);
            }

            Empfänger.Bereich = partner.PART_A_BEREICH;
            Empfänger.Name = partner.PART_A_NAME;
            Empfänger.Vorname = partner.PART_A_VORNAME;
            Empfänger.Anrede = partner.PART_A_BRIEFANREDE;
            return this;
        }

        public async Task<BriefView> SetEmpfängerAsync(LieferantenPartner partner)
        {
            if (partner == null)
            {
                return this;
            }

            if (Empfänger == null)
            {
                Empfänger = new BriefEmpfänger();
            }

            Lieferant? l = await Lieferant.GetLieferantAsync(partner.LIEP_N_LIEFNR);
            if (l != null)
            {
                await SetEmpfängerAsync(l);
            }

            Empfänger.Bereich = partner.LIEP_A_BEREICH;
            Empfänger.Name = partner.LIEP_A_NAME;
            Empfänger.Anrede = partner.LIEP_A_ANREDE;
            return this;
        }
        public BriefView SetAbsender(Personal personal)
        {
            if (personal == null)
            {
                return this;
            }

            if (this.Absender == null)
            {
                this.Absender = new BriefAbsender();
            }

            this.Absender.Email = personal.PERS_A_EMAIL;
            this.Absender.Name = personal.PERS_A_NAME;
            this.Absender.Zeichen = personal.PERS_A_ZEICHEN;
            this.Absender.Telefon = GlobalConfig.Configuration.FirmenDaten.Telefon;
            this.Absender.Fax = GlobalConfig.Configuration.FirmenDaten.Fax;
            return this;
        }

    }

    public class BriefEmpfänger
    {
        public string Strasse { get; set; } = String.Empty;
        public string Ort { get; set; } = String.Empty;
        public string Postleitzahl { get; set; } = String.Empty;
        public Land? Land { get; set; }

        public string? Firma { get; set; }
        public string? Firma2 { get; set; }
        public string? Vorname { get; set; }
        public string? Name { get; set; }
        public string? Bereich { get; set; }
        public string? Anrede { get; set; }

    }

    public class BriefAbsender
    {
        public string? Name { get; set; }
        public string? Telefon { get; set; }
        public string? Fax { get; set; }
        public string? Email { get; set; }
        public string? Zeichen { get; set; }
    }
}
