﻿using System;
using System.Text;

namespace WK5.Core.Drucken.Bestellungen
{
    /// <summary>
    /// Stellt Anzeigedaten für die Generierung einer Bestellung zur Verfügung
    /// </summary>
    public class BestellungView
    {

        public int BEST_N_NR { get; set; }
        public int BEST_N_LIEFNR { get; set; }
        public string? BEST_A_PARTNER { get; set; }
        public DateTime BEST_D_DATE { get; set; }
        public DateTime BEST_D_LIEFTERMIN { get; set; }
        public int BEST_N_ZAHLUNG { get; set; }
        public int BEST_N_LIEFERUNG { get; set; }
        public decimal BEST_N_KURS { get; set; }
        public string BEST_A_WAEHRUNG { get; set; } = String.Empty;
        public decimal BEST_N_NETTO { get; set; }
        public int BEST_N_AB_NR { get; set; }
        public int BEST_N_PROJEKT_NR { get; set; }
        public decimal BEST_N_ZUSATZKOST { get; set; }
        public decimal BEST_N_FRACHT { get; set; }
        public decimal BEST_N_VERPACKUNG { get; set; }
        public decimal BEST_N_VERSICHERUNG { get; set; }
        public decimal BEST_N_RABATT { get; set; }
        public decimal BEST_N_MWST { get; set; }
        public decimal BEST_N_BRUTTO { get; set; }
        public string? BEST_A_ANGEBOTNR { get; set; }
        public DateTime BEST_D_ANGEBOTVOM { get; set; }
        public string? BEST_A_LIEFERKUNDE { get; set; }
        public int BEST_A_LIEFERKUNDELA { get; set; }
        public string? BEST_B_ENDTEXT { get; set; }
        public string? BEST_B_KOPFTEXT { get; set; }
        public string? BEST_B_FUSSTEXT { get; set; }
        public string? BEST_A_RABATTBEZ { get; set; }
        public decimal BEST_N_RABATTPROZ { get; set; }
        public decimal BEST_N_RABATTZUSATZ { get; set; }
        public int LIEF_N_NR { get; set; }
        public string LIEF_A_NAME1 { get; set; } = String.Empty;
        public string? LIEF_A_NAME2 { get; set; }
        public string? LIEF_A_PARTNER { get; set; }
        public string? LIEF_A_STR { get; set; }
        public string? LIEF_A_LAND { get; set; }
        public string? LIEF_A_PLZ { get; set; }
        public string? LIEF_A_ORT { get; set; }
        public string? LIEF_A_FAX { get; set; }
        public string? LIEF_A_EMAIL { get; set; }
        public string? LIEF_A_WAEHRUNG { get; set; }
        public int LIEF_N_LIBD { get; set; }
        public int LIEF_N_ZABD { get; set; }
        public int LIEP_N_LIEFNR { get; set; }
        public int LIEP_N_NR { get; set; }
        public string? LIEP_A_NAME { get; set; }
        public string? LIEP_A_BEREICH { get; set; }
        public string? LIEP_A_TELEFAX { get; set; }
        public string? LIEP_A_EMAIL { get; set; }
        public string? LIEP_A_ANREDE { get; set; }
        public string ZABD_A_TEXT1 { get; set; } = String.Empty;
        public string? ZABD_A_TEXT2 { get; set; }
        public int LIBD_N_NR { get; set; }
        public string LIBD_A_TEXT1 { get; set; } = String.Empty;
        public string? LIBD_A_TEXT2 { get; set; }
        public string? LIBD_A_TEXT3 { get; set; }
        public string? LIBD_A_TEXT4 { get; set; }
        public string? LIBD_A_TEXT5 { get; set; }
        public string? KUND_A_NR { get; set; }
        public string? KUND_A_NAME1 { get; set; }
        public string? KUND_A_NAME2 { get; set; }
        public string? KUND_A_NAME3 { get; set; }
        public string? KUND_A_STRASSE { get; set; }
        public string? KUND_A_LAND { get; set; }
        public string? KUND_A_PLZ { get; set; }
        public string? KUND_A_ORT { get; set; }
        public string? KUND_A_EMAIL { get; set; }
        public string? KUND_A_ANREDE { get; set; }
        public string? KUND_A_ANSPRPARTN { get; set; }
        public string? KUND_A_TEL1 { get; set; }
        public string? KULA_A_KUNDNR { get; set; }
        public int KULA_N_NR { get; set; }
        public string? KULA_A_NAME1 { get; set; }
        public string? KULA_A_NAME2 { get; set; }
        public string? KULA_A_NAME3 { get; set; }
        public string? KULA_A_STRASSE { get; set; }
        public string? KULA_A_LAND { get; set; }
        public string? KULA_A_PLZ { get; set; }
        public string? KULA_A_ORT { get; set; }
        public string? KULA_A_EMAIL { get; set; }
        public string? KULA_A_PARTNER { get; set; }
        public string? KULA_A_TEL { get; set; }
        public string? BELE_A_ZUHAENDEN { get; set; }
        public string GetZahlungsbedingung() => !String.IsNullOrWhiteSpace(ZABD_A_TEXT2)
            ? $"{ZABD_A_TEXT1}<br />{ZABD_A_TEXT2}"
            : ZABD_A_TEXT1;


        public string? GetEmail() => !String.IsNullOrWhiteSpace(LIEP_A_EMAIL)
            ? LIEP_A_EMAIL
            : LIEF_A_EMAIL;

        public string? GetFax() => !String.IsNullOrWhiteSpace(LIEP_A_TELEFAX)
            ? LIEP_A_TELEFAX
            : LIEF_A_FAX;

        public string GetAnlieferadresse()
        {
            StringBuilder sb = new StringBuilder();

            if (BEST_A_LIEFERKUNDELA > 0)
            {
                sb.AppendLine($"{KULA_A_NAME1}<br />");
                if (!String.IsNullOrWhiteSpace(KULA_A_PARTNER))
                {
                    sb.AppendLine($"{KULA_A_PARTNER}<br />");
                }
                sb.AppendLine($"{KULA_A_STRASSE}<br />");
                sb.AppendLine($"{KULA_A_LAND} {KULA_A_PLZ} {KULA_A_ORT}");
                if (!String.IsNullOrWhiteSpace(KULA_A_TEL))
                {
                    sb.AppendLine($"<br /><br />Tel: {KULA_A_TEL}");
                }
                return sb.ToString();
            }
            else if (!String.IsNullOrWhiteSpace(BEST_A_LIEFERKUNDE))
            {
                sb.AppendLine($"{KUND_A_NAME1}<br />");
                if (!String.IsNullOrWhiteSpace(BELE_A_ZUHAENDEN))
                {
                    sb.AppendLine($"{BELE_A_ZUHAENDEN}<br />");
                }
                sb.AppendLine($"{KUND_A_STRASSE}<br />");
                sb.AppendLine($"{KUND_A_LAND} {KUND_A_PLZ} {KUND_A_ORT}");

                if (!String.IsNullOrWhiteSpace(KUND_A_TEL1))
                {
                    sb.AppendLine($"<br /><br />Tel: {KUND_A_TEL1}");
                }
                return sb.ToString();
            }
            else
            {
                return String.Empty;
            }
        }
    }
}
