﻿#define CREATE_PREVIEW_HTML
using iText.Html2pdf;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;
using WK5.Core.Models.Lager;

namespace WK5.Core.Drucken.Abgangsliste
{
    public class PrintAbgangsliste : PrintBase
    {
        private readonly DateTime _von;
        private readonly DateTime _bis;
        private readonly List<AbgangslisteView> _abgänge;
        private readonly List<Kostenstelle> _kostenstellen;

        private PrintAbgangsliste(DateTime von, DateTime bis, List<AbgangslisteView> abgänge, List<Kostenstelle> kostenstellen)
        {
            _von = von;
            _bis = bis;
            _abgänge = abgänge;
            _kostenstellen = kostenstellen;
            _layoutFile = "Abgangsliste.html";
            _template = String.Empty;
        }
        
        public static async Task<PrintAbgangsliste> CreateAsync(DateTime von, DateTime bis, List<AbgangslisteView> abgänge, List<Kostenstelle> kostenstellen)
        {
            var myClass = new PrintAbgangsliste(von, bis, abgänge, kostenstellen);
            await myClass.InitializeAsync();
            return myClass;
        }
        public override string Print(string speicherpfad)
        {
            string filename = $"ABGANGSLISTE_{_von:yyyy-MM-dd}_{_bis:yyyy-MM-dd}.pdf";

#if CREATE_PREVIEW_HTML
            File.WriteAllText(Path.Combine(speicherpfad, $"ABGANGSLISTE_{_von:yyyy-MM-dd}_{_bis:yyyy-MM-dd}.html"), _template);
#endif
            byte[] byteArray = Encoding.UTF8.GetBytes(_template);
            MemoryStream stream = new MemoryStream(byteArray);
            ConverterProperties converterProperties = new ConverterProperties()
                .SetBaseUri(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, LAYOUT_PATH));

            string fullPath = Path.Combine(speicherpfad, filename);
            if (File.Exists(fullPath))
            {
                File.Delete(fullPath);
            }

            HtmlConverter.ConvertToPdf(stream, new FileStream(fullPath, FileMode.OpenOrCreate, FileAccess.ReadWrite, FileShare.None), converterProperties);

            return fullPath;
        }

        protected override string GenerateDisplayCss()
        {
            return String.Empty;
        }

        protected override async Task InitializeAsync()
        {
            string layoutPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, LAYOUT_PATH, _layoutFile);
            _template = await File.ReadAllTextAsync(layoutPath);
            SetRegeln();
            _template = await SetTemplateVariables();
        }

        protected override Task InitializeAsync(FbController2 fbController)
        {
            throw new NotImplementedException();
        }

        protected override void SetRegeln()
        {
            return;
        }

        protected override Task<string> SetTemplateVariables()
        {
            StringBuilder viewBuilder = new StringBuilder();

            foreach (var abgang in _abgänge)
            {
                viewBuilder.AppendLine("<tr>");
                //viewBuilder.AppendLine("\t<td class=\"nowrap\">");
                //viewBuilder.AppendLine($"\t\t{abgang.ARAB_N_NR}");
                //viewBuilder.AppendLine("\t</td>");

                viewBuilder.AppendLine("\t<td class=\"nowrap\">");
                viewBuilder.AppendLine($"\t\t{abgang.ARAB_A_ARTIKEL}");
                viewBuilder.AppendLine("\t</td>");

                viewBuilder.AppendLine("\t<td>");
                viewBuilder.AppendLine($"\t\t{abgang.ARTI_A_BEZ1}");
                viewBuilder.AppendLine("\t</td>");

                viewBuilder.AppendLine("\t<td>");
                viewBuilder.AppendLine($"\t\t{abgang.ARAB_N_KOSTENSTELL}");
                viewBuilder.AppendLine("\t</td>");

                //viewBuilder.AppendLine("\t<td>");
                //viewBuilder.AppendLine($"\t\t{abgang.ARAB_N_CHARGE}");
                //viewBuilder.AppendLine("\t</td>");

                viewBuilder.AppendLine("\t<td>");
                viewBuilder.AppendLine($"\t\t{abgang.ARAB_D_DATUM.ToShortDateString()}");
                viewBuilder.AppendLine("\t</td>");

                viewBuilder.AppendLine("\t<td>");
                viewBuilder.AppendLine($"\t\t{abgang.ARAB_N_MENGE:0.00} {abgang.ARTI_A_EINHEIT}");
                viewBuilder.AppendLine("\t</td>");

                viewBuilder.AppendLine("\t<td>");
                viewBuilder.AppendLine($"\t\t{abgang.ARAB_N_EINZELPREIS:0.00}");
                viewBuilder.AppendLine("\t</td>");
                viewBuilder.AppendLine("\t<td>");
                viewBuilder.AppendLine($"\t\t{abgang.GESAMTPREIS:0.00}");
                viewBuilder.AppendLine("\t</td>");
                viewBuilder.AppendLine("</tr>");
            }

            // Abgang pro Kostenstelle bestimmen
            IEnumerable<int> kostenstellen = _abgänge.Select(x => x.ARAB_N_KOSTENSTELL).Distinct().OrderBy(x => x);

            StringBuilder zusammenfassungBuilder = new StringBuilder();

            foreach (var kostenstelle in kostenstellen)
            {
                Kostenstelle? kostenstelleObj = _kostenstellen.FirstOrDefault(x => x.KOST_N_NR == kostenstelle);
                decimal gesamtsumme = _abgänge.Where(x => x.ARAB_N_KOSTENSTELL == kostenstelle).Sum(x => x.GESAMTPREIS);
                zusammenfassungBuilder.AppendLine("<tr>");

                zusammenfassungBuilder.AppendLine("\t<td class=\"nowrap\">");
                zusammenfassungBuilder.AppendLine($"\t\t{kostenstelle}");
                if(kostenstelleObj is not null)
                {
                    zusammenfassungBuilder.AppendLine($"\t\t<br />");
                    zusammenfassungBuilder.AppendLine($"\t\t{kostenstelleObj.KOST_A_BEZEICH}");
                }
                zusammenfassungBuilder.AppendLine("\t</td>");

                zusammenfassungBuilder.AppendLine("\t<td class=\"nowrap\">");
                zusammenfassungBuilder.AppendLine($"\t\t{gesamtsumme:0.00}");
                zusammenfassungBuilder.AppendLine("\t</td>");

                zusammenfassungBuilder.AppendLine("</tr>");
            }

            _template = _template
                .Replace("{{ DISPLAY_CSS }}", GenerateDisplayCss())
                .Replace("{{ ABGAENGE }}", viewBuilder.ToString())
                .Replace("{{ DATUM }}", DateTime.Now.ToLongDateString())
                .Replace("{{ VON }}", _von.ToShortDateString())
                .Replace("{{ BIS }}", _bis.ToShortDateString())
                .Replace("{{ GESAMTSUMME }}", _abgänge.Sum(x => x.GESAMTPREIS).ToString("0.00"))
                .Replace("{{ KOSTENSTELLEN_ZUSAMMENFASSUNG }}", zusammenfassungBuilder.ToString())
                ;

            return Task.FromResult(_template);
        }
    }
}
