﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis
{
    /// <summary>
    /// Generalisiert die Einbindung von mehreren Tabs.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface ITabPage<T> where T : Enum
    {
        /// <summary>
        /// Wird ausgeführt, wenn der aktive Tab sich ändern soll.
        /// </summary>
        /// <param name="newActiveTab"></param>
        /// <returns></returns>
        public Task OnTabChange(T newActiveTab);
        /// <summary>
        /// Tabs die nur im Bearbeiten Modus angezeigt werden sollen.
        /// </summary>
        List<T> EditOnlyTabs { get; set; }
        /// <summary>
        /// Tabs die nur für Administratoren angezeigt werden sollen
        /// </summary>
        List<T> AdminOnlyTabs { get; set; }
        /// <summary>
        /// Ruft den derzeit aktiven Tab ab, oder legt diesen fest.
        /// </summary>
        T ActiveTab { get; set; }
    }
}
