﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis
{
    /// <summary>
    /// Standartisiert die CRUD-Operations von Model-Services 
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface IModelService<T>
    {
        /// <summary>
        /// Speichert das Objekt in der Datenbank als neuen Datensatz.
        /// </summary>
        /// <param name="input"></param>
        /// <param name="fbController"></param>
        /// <returns></returns>
        Task CreateAsync(T input, FbController2 fbController);
        /// <summary>
        /// Aktualisiert den Datensatz für das Objekt in der Datenbank
        /// </summary>
        /// <param name="input"></param>
        /// <param name="fbController"></param>
        /// <returns></returns>
        Task UpdateAsync(T input, FbController2 fbController);
    }
    /// <summary>
    /// <inheritdoc/>
    /// <para>
    /// Erweitert die Standard CRUD Operations noch um das Laden eines einzelnen Objektes.
    /// </para>
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <typeparam name="GetKeyIdentifier"></typeparam>
    public interface IModelService<T, TIdentifier> : IModelService<T>
    {
        /// <summary>
        /// Lädt ein Objekt aus der Datenbank für einen besteimmten Identifier
        /// </summary>
        /// <param name="identifier">Identifier, wie das Objekt in der Datenbank identifiziert werden kann.</param>
        /// <param name="fbController"></param>
        /// <returns>
        /// Wenn das Objekt in der Datenbank für den Identifier existiert, dann wird dieses zurückgeben. Ansonsten wird null zurückgegeben.
        /// </returns>
        Task<T?> GetAsync(TIdentifier identifier, FbController2 fbController);
    }
}
