﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class WarengruppenFilter : Filter
    {

        public override string ToSqlQuery(FbController2 fbController)
        {

            sqlBuilder.Append("SELECT FIRST 30 * FROM WARENGRUPPE WHERE 1 = 1");

            BuildQueryConditions(fbController);

            string tmp = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return tmp;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                if (Suchbegriff.Length > 255)
                {
                    throw new ArgumentOutOfRangeException(nameof(Suchbegriff));
                }

                sqlBuilder.Append($@" AND 
(
   CAST(UPPER(WAGR_A_NR) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(UPPER(WAGR_A_BEZEICH) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(UPPER(WAGR_A_BESCH1) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(UPPER(WAGR_A_BESCH2) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(UPPER(WAGR_A_BESCH3) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
)");
                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }
        }
    }

}
