﻿using System;

namespace WK5.Core.Basis.Filter
{
    public class UnterwarengruppenFilter : Filter
    {
        public string Warengruppe { get; set; } = String.Empty;
        public override string ToSqlQuery(FbController2 fbController)
        {

            sqlBuilder.Append("SELECT FIRST 30 * FROM UNTERWARENGRUPPE WHERE 1=1");

            BuildQueryConditions(fbController);

            string tmp = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return tmp;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append(" AND UNWG_A_WARENGR = @WARENGRUPPE");

            fbController.AddParameter("@WARENGRUPPE", Warengruppe);
            if (!String.IsNullOrWhiteSpace(Suchbegriff))
            {
                if (Suchbegriff.Length > 255)
                {
                    throw new ArgumentOutOfRangeException(nameof(Suchbegriff));
                }

                sqlBuilder.AppendLine($@" AND 
(
   CAST(UPPER(UNWG_A_NR) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
OR CAST(UPPER(UNWG_A_BEZEICH) AS VARCHAR(255)) LIKE @SUCHBEGRIFF
)");

                fbController.AddParameter("@SUCHBEGRIFF", $"%{Suchbegriff}%");
            }
        }
    }

}
