﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter.Statistik
{
    public class MitarbeiterStatistikFilter : Filter
    {
        public string Typ { get; set; } = "RE";
        public int MitarbeiterId { get; set; }
        public DateTime From { get; set; }
        public DateTime To { get; set; }

        public MitarbeiterStatistikFilter()
        {
            DateTime letzterMonat = DateTime.Now.AddMonths(-1);
            From = new DateTime(letzterMonat.Year, letzterMonat.Month, 1);
            To = new DateTime(letzterMonat.Year, letzterMonat.Month, DateTime.DaysInMonth(letzterMonat.Year, letzterMonat.Month));
        }
        public override string ToSqlQuery(FbController2 fbController)
        {
            switch (Typ)
            {
                case "AN" or "AU" or "LS" or "RE" or "GU":
                    sqlBuilder.AppendLine("SELECT BELE_A_TYP AS TYP, BELE_N_NR AS ZUORDNUNGSNUMMER FROM BELEGE WHERE 1 = 1");
                    break;
                case "BE":
                    sqlBuilder.AppendLine("SELECT 'BE' AS TYP, BEST_N_NR AS ZUORDNUNGSNUMMER FROM BESTELLUNGEN WHERE 1 = 1");
                    break;
                default:
                    break;
            }

            BuildQueryConditions(fbController);

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
            
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            switch (Typ)
            {
                case "AN" or "AU" or "LS" or "RE" or "GU":
                    sqlBuilder.AppendLine(" AND BELE_N_ANLAGEUSER = @MITARBEITER_ID AND BELE_A_TYP = @TYP AND BELE_D_DATE BETWEEN @FROM AND @TO");
                    break;
                case "BE":
                    sqlBuilder.AppendLine(" AND BEST_N_ANLAGEUSER = @MITARBEITER_ID AND BEST_D_DATE BETWEEN @FROM AND @TO");
                    break;
                default:
                    break;
            }
        }
    }
}
