﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter.Statistik
{
    public class LieferantenUmsatzFilter : Filter
    {
        public Zeitraum Zeitraum { get; set; }
        public int AnzahlMaxErgebnisse { get; set; } = 30;
        public FilterUmsatzOrt Option { get; set; } = FilterUmsatzOrt.AlleUmsätze;
        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Append($"SELECT FIRST {AnzahlMaxErgebnisse} SKIP 0 * FROM PROZ_LIEFERANTENSTATISTIK(");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(')');

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append("@INP_ANZ, @INP_VON, @INP_BIS,");
            fbController.AddParameter("@INP_ANZ", AnzahlMaxErgebnisse);
            fbController.AddParameter("@INP_VON", Zeitraum.Von.ToShortDateString());
            fbController.AddParameter("@INP_BIS", Zeitraum.Bis.ToShortDateString());
            sqlBuilder.Append(Option switch
            {
                FilterUmsatzOrt.AlleUmsätze => " 'Y', 'N', 'N', 'N'",
                FilterUmsatzOrt.Inland => " 'N', 'Y', 'N', 'N'",
                FilterUmsatzOrt.EuAusland => " 'N', 'N', 'Y', 'N'",
                FilterUmsatzOrt.NichtEuAusland => " 'N', 'N', 'N', 'Y'",
                _ => throw new NotImplementedException()
            });
        }

        public LieferantenUmsatzFilter()
        {
            Zeitraum = new Zeitraum(new DateTime(DateTime.Today.Year -1, 1,1), new DateTime(DateTime.Today.Year -1, 12, 31));
        }
    }
}
