﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter.Statistik
{
    
    public class ErlöskalkulatorFilter : Filter
    {
        public BelegTyp Typ { get; set; } = BelegTyp.Rechnung;
        public DateTime From { get; set; }
        public DateTime To { get; set; } = DateTime.Now;
        public int BearbeiterId { get; set; }
        public int VertreterId { get; set; }

        public ErlöskalkulatorFilter()
        {
            From = DateTime.Today.AddDays((-(int)DateTime.Today.DayOfWeek) + 1);
        }

        public override string ToSqlQuery(FbController2 fbController)
        {
            /* MK: Wir nicht den Wert aus WK5_BPOS_N_EK nehmen, da ein Artikel aus mehreren Chargen kommen kann, welche unterschiedliche Preise aufweisen, daher joinen wir auf Chargen.
             * Wenn ein Artikel nicht gechargt worden ist, dann nehmen wir den Wert auf WK5_BPOS_N_EK als Grundlage für die Berechnung. Im Normalfall sind das Artikel ohne Lagerführung, kann aber auch ggf. DIVERS sein, was nicht gechargt wurde.
             * Die Berechnung des EKs von Zugängen vor dem 16.11.21 ist noch falsch, da hier beim zubuchen ein Fehler in der Berechnung des EKs passiert ist.
             */

            sqlBuilder.AppendLine(@"SELECT BELE_A_TYP, BELE_N_NR, BELE_N_VERTRETER, BELE_N_LASTUSER, SUM(EK) AS EK, SUM(VK) as VK
FROM
(
    SELECT  
    BELE_A_TYP, BELE_N_NR, BELE_N_VERTRETER, BELE_N_LASTUSER,
    CASE WHEN BELE_A_TYP = 'GU' THEN
        -PREIS_MIT_RABATT
    ELSE
        SUM(NETTO)
    END AS EK,
    CASE WHEN BELE_A_TYP = 'GU' THEN
        -PREIS_MIT_RABATT
    ELSE
        PREIS_MIT_RABATT
    END AS VK 
    FROM 
    (
        SELECT  
        CASE WHEN A.ARTI_L_BUNDLE = 'N' THEN
            CASE WHEN C.CHAR_N_EKPREIS IS NULL THEN
            BP.WK5_BPOS_N_EK * BP.BPOS_N_MENGE
        ELSE
            C.CHAR_N_EKPREIS * BC.BCHA_N_MENGE
        END
        ELSE
           0
        END AS NETTO,
        BELE_A_TYP, 
        BELE_N_NR,
        BPOS_N_POS,
        BPOS_N_POSID,
        BELE_N_VERTRETER,
        BELE_N_LASTUSER,
        BC.BCHA_N_CHARGE,
        C.CHAR_N_EKPREIS,
        BPOS_N_MENGE * BPOS_N_PREIS * (100 - coalesce(BP.BPOS_N_RABATTPROZ, 0)) / 100 * (100 - coalesce(BP.BPOS_N_RABATTPROZ2, 0)) / 100 AS PREIS_MIT_RABATT
        FROM
        belege b 
        LEFT JOIN LIEFERBEDINGUNG ON (LIBD_N_NR = BELE_N_LIEFERUNG)
        LEFT JOIN BELEGPOS BP ON (BPOS_A_TYP = BELE_A_TYP AND BPOS_N_NR = BELE_N_NR)
        LEFT JOIN BELEGCHARGEN BC ON (BC.BCHA_N_POSID = BP.BPOS_N_POSID)
        LEFT JOIN CHARGEN C ON (C.CHAR_N_NR = BC.BCHA_N_CHARGE)
        LEFT JOIN ARTIKEL A ON A.ARTI_A_NR = BP.BPOS_A_ARTIKELNR
        LEFT JOIN ARTIKEL A2 ON A2.ARTI_A_NR = C.CHAR_A_ARTINR
        WHERE BELE_A_TYP = @BELE_A_TYP AND BELE_D_DATE BETWEEN @FROM AND @TO
        AND BP.BPOS_A_ARTIKELNR NOT IN ('TEXT')");
            BuildQueryConditions(fbController);
            sqlBuilder.AppendLine(@"
    )
    GROUP BY  BELE_N_VERTRETER,BELE_N_LASTUSER, BELE_A_TYP, BELE_N_NR, BPOS_N_POSID, PREIS_MIT_RABATT, BPOS_N_POS
)
GROUP BY BELE_A_TYP, BELE_N_NR, BELE_N_VERTRETER, BELE_N_LASTUSER");

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            if (VertreterId > 0)
            {
                sqlBuilder.AppendLine(" AND BELE_N_VERTRETER = @BELE_N_VERTRETER");
            }

            if (BearbeiterId > 0)
            {
                sqlBuilder.AppendLine(" AND BELE_N_LASTUSER = @BELE_N_LASTUSER");
            }
        }
    }
}
