﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter.Statistik
{
    public class ArtikelUmsatzFilter : Filter
    {
        public Zeitraum Zeitraum { get; set; }
        public ArtikelUmsatzOption Option { get; set; } = ArtikelUmsatzOption.Umsatz;

        public int AnzahlMaxErgebnisse { get; set; } = 30;
        public string Warengruppe { get; set; } = string.Empty;
        public string Unterwarengruppe { get; set; } = string.Empty;
        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Append(@$"select first {AnzahlMaxErgebnisse}
{Option switch
            {
                ArtikelUmsatzOption.Umsatz => "sum(iif(bpos_a_typ = 'RE', BPOS_N_MENGE, -BPOS_N_MENGE) * BPOS_N_PREIS)",
                ArtikelUmsatzOption.Menge => "sum(iif(bpos_a_typ = 'RE',BPOS_N_MENGE, -BPOS_N_MENGE))",
                _ => throw new ArgumentOutOfRangeException(nameof(Option))
            }}
as wert,
bpos_a_artikelnr,
arti_a_bez1,
arti_a_bez2
from  BELEGE
left outer join belegpos on bpos_n_nr = bele_n_nr and bpos_a_typ = bele_a_typ
left outer join artikel on arti_a_nr = bpos_a_artikelnr
where (BELE_A_TYP = 'RE' or BELE_A_TYP = 'GU')");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(@" 
group by bpos_a_artikelnr,arti_a_bez1,arti_a_bez2
order by 1 desc");

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append(" AND BELE_D_DATE >= @START and BELE_D_DATE <= @ENDE");
            fbController.AddParameter("@START", Zeitraum.Von.ToShortDateString());
            fbController.AddParameter("@ENDE", Zeitraum.Bis.ToShortDateString());

            if(!String.IsNullOrWhiteSpace(Warengruppe))
            {
                sqlBuilder.Append(" AND ARTI_A_WARENGRUPPE = @ARTI_A_WARENGRUPPE");
                fbController.AddParameter("@ARTI_A_WARENGRUPPE", Warengruppe);
            }

            if (!String.IsNullOrWhiteSpace(Unterwarengruppe))
            {
                sqlBuilder.Append(" AND ARTI_A_UNTERWARENG = @ARTI_A_UNTERWARENG");
                fbController.AddParameter("@ARTI_A_UNTERWARENG", Unterwarengruppe);
            }
        }

        public ArtikelUmsatzFilter()
        {
            Zeitraum = new Zeitraum(new DateTime(DateTime.Today.Year - 1, 1, 1), new DateTime(DateTime.Today.Year - 1, 12, 31));
        }
    }
}
