﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Basis.Filter.Statistik
{
    public class AbgelehnteAngeboteFilter : Filter
    {
        public string Artikelnummer { get; set; } = string.Empty;
        public string Warengruppe { get; set; } = string.Empty;
        public string Unterwarengruppe { get; set; } = string.Empty;
        public Zeitraum Zeitraum { get; set; }
        public AbgelehnteAngeboteFilter()
        {
            DateTime letzterMonat = DateTime.Now.AddMonths(-1);

            DateTime start = new DateTime(letzterMonat.Year, letzterMonat.Month, 1);
            DateTime ende = new DateTime(letzterMonat.Year, letzterMonat.Month, DateTime.DaysInMonth(letzterMonat.Year, letzterMonat.Month));
            Zeitraum = new Zeitraum(start, ende);
        }
        public override string ToSqlQuery(FbController2 fbController)
        {
            sqlBuilder.Append(@"SELECT ABGR_N_ID, A.ABGR_A_GRUND, COUNT(*) AS ANZAHL 
FROM BELEGE B
LEFT JOIN ABLEHNUNGSGRUENDE A ON (A.ABGR_N_ID = B.BELE_N_ABLEHNUNG)
WHERE BELE_A_TYP = 'AN' AND B.BELE_N_ABLEHNUNG > 0");
            BuildQueryConditions(fbController);
            sqlBuilder.Append(@"
GROUP BY A.ABGR_N_ID, A.ABGR_A_GRUND");

            string sql = sqlBuilder.ToString();
            sqlBuilder.Clear();
            return sql;
        }

        protected override void BuildQueryConditions(FbController2 fbController)
        {
            sqlBuilder.Append(" AND BELE_D_DATE BETWEEN @START AND @ENDE");
            fbController.AddParameter("@START", Zeitraum.Von.ToShortDateString());
            fbController.AddParameter("@ENDE", Zeitraum.Bis.ToShortDateString());

            if(!String.IsNullOrEmpty(Warengruppe) || !string.IsNullOrWhiteSpace(Unterwarengruppe))
            {
                sqlBuilder.Append(@" AND EXISTS 
(
    SELECT 1 FROM BELEGPOS BP
    LEFT JOIN ARTIKEL A ON A.ARTI_A_NR = BP.BPOS_A_ARTIKELNR
    WHERE BPOS_A_TYP = 'AN' AND BPOS_N_NR = BELE_N_NR");
                if(!String.IsNullOrEmpty(Warengruppe))
                {
                    sqlBuilder.Append(" AND ARTI_A_WARENGRUPPE = @ARTI_A_WARENGRUPPE");
                    fbController.AddParameter("@ARTI_A_WARENGRUPPE", Warengruppe);
                }

                if (!String.IsNullOrEmpty(Unterwarengruppe))
                {
                    sqlBuilder.Append(" AND ARTI_A_UNTERWARENG = @ARTI_A_UNTERWARENG");
                    fbController.AddParameter("@ARTI_A_UNTERWARENG", Unterwarengruppe);
                }

                sqlBuilder.Append(@"
)");

            }
        }

        
    }
}
